package com.biz.crm.util;

import com.biz.crm.base.BusinessException;
import org.apache.commons.lang3.StringUtils;

import java.text.SimpleDateFormat;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;

public class CrmDateUtils {
    private CrmDateUtils(){}
    public static final DateTimeFormatter yyyyMMddHHmmssSSS = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss,SSS");
    public static final DateTimeFormatter yyyyMMddHHmmss = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
    public static final DateTimeFormatter yyyyMMdd = DateTimeFormatter.ofPattern("yyyy-MM-dd");
    public static final DateTimeFormatter HHmmss = DateTimeFormatter.ofPattern("HH:mm:ss");
    /**
     * 12:00:00
     */
    public static final String TIME_STR_12 = "12:00:00";
    /**
     * 每天最早的时刻
     */
    public static final String TIME_STR_00 = "00:00:00";

    /**
     * 每天最晚的时刻
     */
    public static final String TIME_STR_235959 = "23:59:59";

    /**
     * 字符转日期时间
     * @param dateTime
     * @return
     */
    public static LocalDateTime parseyyyyMMddHHmmss(String dateTime){
        try {
            return LocalDateTime.parse(dateTime, yyyyMMddHHmmss);
        }catch (Exception e){
            throw new BusinessException("格式化日期时间失败！", e);
        }

    }

    /**
     * date + time 字符转日期时间
     *
     * @param date 日期
     * @param time 时间
     * @param maxTime 当时间为空或为 00:00:00 时, false:使用最小时间(00:00:00),true:使用最大时间(23:59:59)
     * @return
     */
    public static LocalDateTime parseCrmDateTime(String date, String time, boolean maxTime){
        if(StringUtils.isBlank(date)){
            return null;
        }
        String onEmptyTime = maxTime ? TIME_STR_235959 : TIME_STR_00;
        return parseyyyyMMddHHmmss(date + " " + (StringUtils.isBlank(time) || TIME_STR_00.equals(time) ? onEmptyTime : time));
    }

    /**
     * 验证字符串是否指定日期格式
     * @param dateStr
     * @param format
     * @return
     */
    public static boolean validFormat(String dateStr, String format) {
        if(StringUtils.isEmpty(dateStr)) {
            return false;
        }
        try{
            new SimpleDateFormat(format).parse(dateStr);
        }catch(Exception e){
            return false;
        }
        return true;
    }


}
