package com.biz.crm.util;

import com.biz.crm.base.BusinessException;
import com.biz.crm.common.param.RedisParam;
import com.biz.crm.dict.feign.MdmDictFeign;
import com.biz.crm.nebular.mdm.dict.resp.MdmDictAttrConfRespVo;
import com.biz.crm.nebular.mdm.dict.resp.MdmDictDataRespVo;
import com.biz.crm.nebular.mdm.dict.resp.MdmDictGroupVo;
import com.biz.crm.service.RedisService;
import lombok.extern.slf4j.Slf4j;

import java.util.*;

/**
 * @author zxw
 **/
@Slf4j
public class DictUtil {

    private static RedisService redisService;

    private static MdmDictFeign mdmDictFeign;

    public static void setRedisService(RedisService redis) {
        redisService = redis;
    }

    public static void setMdmDictFeign(MdmDictFeign mdmDictFeign) {
        DictUtil.mdmDictFeign = mdmDictFeign;
    }

    /**
     * 根据字典类型编码集合查询对应的value的map集合
     *
     * @param dictTypeCodes 分类编码集合
     * @return map
     */
    public static Map<String, Map<String, String>> getDictValueMapsByCodes(List<String> dictTypeCodes) {
        Map<String, Map<String, String>> maps = new HashMap<>(16);
        if (dictTypeCodes != null && dictTypeCodes.size() > 0) {
            for (String dictTypeCode :
                    dictTypeCodes) {
                maps.put(dictTypeCode, dictMap(dictTypeCode));
            }
        }
        return maps;
    }

    /**
     * 根据字典类型编码查询对应的值的集合
     *
     * @param dictTypeCode 分类编码
     * @return map
     */
    public static Map<String, String> getDictValueMapsByCodes(String dictTypeCode) {
        return dictMap(dictTypeCode);
    }

    /**
     * 根据字典类型编码和字典编码获取字典值
     *
     * @param dictTypeCode 字典类型编码
     * @param dictCode     字典编码
     * @return 字典值
     */
    public static String getDictDataVal(String dictTypeCode, String dictCode) {
        if (StringUtils.isNotEmpty(dictTypeCode) && StringUtils.isNotEmpty(dictCode)) {
            Map<String, String> dictMap = dictMap(dictTypeCode);
            if (!dictMap.isEmpty()) {
                return dictMap.get(dictCode);
            }
        }
        return "";
    }

    /**
     * 根据字典类型编码、字典编码、扩展字典编码获取扩展字典得值
     *
     * @param dictCode        字典类型编码
     * @param dictTypeCode    字典编码
     * @param extendFieldCode 字典扩展字段编码
     * @return 字典值
     */
    public static String getDictDataExtendVal(String dictTypeCode, String dictCode, String extendFieldCode) {
        if (StringUtils.isNotEmpty(dictTypeCode) && StringUtils.isNotEmpty(dictCode) && StringUtils.isNotEmpty(extendFieldCode)) {
            MdmDictGroupVo dictGroup = getDictGroup(dictTypeCode);
            if (dictGroup != null) {
                for (MdmDictDataRespVo item :
                        dictGroup.getDataList()) {
                    if (dictCode.equals(item.getDictCode())) {
                        List<MdmDictAttrConfRespVo> confList = dictGroup.getConfList();
                        if (confList != null && confList.size() > 0) {
                            for (MdmDictAttrConfRespVo conf :
                                    confList) {
                                if (extendFieldCode.equals(conf.getFieldCode())) {

                                    Object filedValueByName = ReflectUtil.getFiledValueByName(item, conf.getExtField());
                                    if (filedValueByName != null) {
                                        return filedValueByName.toString();
                                    }
                                    break;
                                }
                            }
                        }
                        break;
                    }
                }
            }
        }
        return "";
    }

    /**
     * 根据字典类型编码、字典编码查询扩展字段map
     *
     * @param dictCode     字典类型编码
     * @param dictTypeCode 字典编码
     * @return 字典值
     */
    public static Map<String, String> getDictDataExtendMap(String dictTypeCode, String dictCode) {
        Map<String, String> map = new HashMap<>();
        if (StringUtils.isNotEmpty(dictTypeCode) && StringUtils.isNotEmpty(dictCode)) {
            MdmDictGroupVo dictGroup = getDictGroup(dictTypeCode);
            if (dictGroup != null) {
                for (MdmDictDataRespVo item :
                        dictGroup.getDataList()) {
                    if (dictCode.equals(item.getDictCode())) {
                        List<MdmDictAttrConfRespVo> confList = dictGroup.getConfList();
                        if (confList != null && confList.size() > 0) {
                            for (MdmDictAttrConfRespVo conf :
                                    confList) {
                                Object filedValueByName = ReflectUtil.getFiledValueByName(item, conf.getExtField());
                                if (filedValueByName != null) {
                                    map.put(conf.getFieldCode(), filedValueByName.toString());
                                } else {
                                    map.put(conf.getFieldCode(), "");
                                }
                            }
                        }
                        break;
                    }
                }
            }
        }
        return map;
    }

    /**
     * 根据字典类型编码、字典编码获取当前值得下一级字典集合
     *
     * @param dictCode     字典类型编码
     * @param dictTypeCode 字典编码
     * @return 字典值
     */
    public static Map<String, String> getDictDataSingleChildren(String dictTypeCode, String dictCode) {
        Map<String, String> map = new HashMap<>();
        if (StringUtils.isNotEmpty(dictTypeCode) && StringUtils.isNotEmpty(dictCode)) {
            MdmDictGroupVo dictGroup = getDictGroup(dictTypeCode);
            if (dictGroup != null) {
                for (MdmDictDataRespVo item :
                        dictGroup.getDataList()) {
                    if (dictCode.equals(item.getDictCode())) {
                        for (MdmDictDataRespVo maybeChildItem :
                                dictGroup.getDataList()) {
                            if (StringUtils.isNotEmpty(maybeChildItem.getParentDictCode()) && maybeChildItem.getParentDictCode().equals(item.getDictCode())) {
                                map.put(maybeChildItem.getDictCode(), maybeChildItem.getDictValue());
                            }
                        }
                        break;
                    }
                }
            }
        }
        return map;
    }

    /**
     * 根据字典类型编码、字典编码获取当前值得上一级字典的值
     *
     * @param dictCode     字典类型编码
     * @param dictTypeCode 字典编码
     * @return 字典值
     */
    public static String getDictDataSingleParent(String dictTypeCode, String dictCode) {
        if (StringUtils.isNotEmpty(dictTypeCode) && StringUtils.isNotEmpty(dictCode)) {
            MdmDictGroupVo dictGroup = getDictGroup(dictTypeCode);
            if (dictGroup != null) {
                for (MdmDictDataRespVo item :
                        dictGroup.getDataList()) {
                    if (dictCode.equals(item.getDictCode())) {
                        if (StringUtils.isNotEmpty(item.getParentDictCode())) {
                            for (MdmDictDataRespVo maybeParentItem :
                                    dictGroup.getDataList()) {
                                if (item.getParentDictCode().equals(maybeParentItem.getDictCode())) {
                                    return maybeParentItem.getDictCode();
                                }
                            }
                        }
                        break;
                    }
                }
            }
        }
        return "";
    }

    /**
     * 根据字典类型编码查询对应的值的集合
     *
     * @param dictTypeCode 字典类型编码
     * @return map
     */
    public static Map<String, String> dictMap(String dictTypeCode) {
        Map<String, String> map = new LinkedHashMap<>(16);
        if (dictTypeCode != null && !"".equals(dictTypeCode)) {
            MdmDictGroupVo dict = getDictGroup(dictTypeCode);
            if (dict != null) {
                for (MdmDictDataRespVo item :
                        dict.getDataList()) {
                    map.put(item.getDictCode(), item.getDictValue());
                }
            }
        }
        return map;
    }

    private static MdmDictGroupVo getDictGroup(String dictTypeCode) {
        MdmDictGroupVo group = null;
        if (dictTypeCode != null) {
            if (redisService.get(RedisParam.DICT_TYPE_LOCK + dictTypeCode) == null) {
                Object groupObj = redisService.get(RedisParam.DICT_TYPE_GROUP + dictTypeCode);
                if (groupObj != null) {
                    group = (MdmDictGroupVo) groupObj;
                } else {
                    Result<MdmDictGroupVo> result = mdmDictFeign.getMdmDict(dictTypeCode);
                    if (!result.isSuccess()) {
                        throw new BusinessException("获取数据字典失败：" + result.getMessage());
                    }
                    if (result.getResult() == null) {
                        redisService.setSeconds(RedisParam.DICT_TYPE_LOCK + dictTypeCode, dictTypeCode, RedisParam.TIME5);
                        return null;
                    }
                    group = result.getResult();
                }
            }
        }
        return group;
    }

    private static Map<String, MdmDictGroupVo> getDictGroupList(List<String> dictTypeCodeList) {
        Map<String, MdmDictGroupVo> map = new HashMap<>();
        //TODO
        return map;
    }


}
