package com.biz.crm.dict.entity;


import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;

import java.util.Date;

/**
 * 数据字典导出模型vo
 * @author  zxw
 */
@AllArgsConstructor
@NoArgsConstructor
@Data
@Accessors(chain = true)
public class DictExportVo {

  private String id;

  /**
   * 创建者账号
   */
  @ApiModelProperty("创建者账号")
  private String creator;

  /**
   * 创建时间
   */
  @ApiModelProperty("创建时间")
  private Date createTime;

  /**
   * 导出数据项，如果没有执行数据项，则表示导出所有数据
   */
  @ApiModelProperty("导出数据项")
  private String datas;

}
