package com.biz.crm.util;

import com.biz.crm.base.BusinessException;
import java.util.Collection;
import java.util.List;

/**
 * @Description:
 * @Author: zhangyuzhu
 * @Date: 2020/9/3 17:37
 **/
public class ValidateUtils {


  /**
   * 验证方法
   * @param obj
   * @param errMsg
   */
  public static void validate(Object obj, String errMsg) {
    if (obj == null || obj.toString().equals("")) {
      throw new BusinessException(errMsg);
    }
  }

  /**
   * 验证集合为空
   * @param collection
   * @param errMsg
   */
  public static void isEmpty(Collection collection, String errMsg) {
    if (collection != null && collection.size() > 0) {
      throw new BusinessException(errMsg);
    }
  }

  /**
   * 验证集合为空
   * @param collection
   * @param errMsg
   */
  public static void notEmpty(Collection collection, String errMsg) {
    if (collection ==null || collection.size() == 0) {
      throw new BusinessException(errMsg);
    }
  }
}
