package com.biz.crm.config;

import com.biz.crm.common.PageResult;
import com.biz.crm.util.DictUtil;
import com.biz.crm.util.Result;
import com.biz.crm.util.StringUtils;
import com.google.common.collect.Maps;
import lombok.SneakyThrows;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.springframework.stereotype.Component;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;

/**
 * 数据字典填充
 *
 * @author zxw
 * @date 2020-09-24 13:19
 **/
@Component
@Aspect
public class CrmDictMethodAop {

    @SneakyThrows
    @Around("@annotation(CrmDictMethod)")
    public Object around(ProceedingJoinPoint pjp) {
        Object proceed = pjp.proceed();
        Map<String, Map<String, String>> map = Maps.newHashMap();
        if (proceed instanceof Result) {

            Object data = objParse(Result.class, proceed).getResult();
            if (data != null) {
                if (data.getClass().isArray() || data instanceof Collection) {
                    Collection<Object> collections = listParse(Object.class, data);
                    for (Object datum : collections) {
                        convertData(datum, map);
                    }
                } else if (data instanceof PageResult) {
                    Collection<Object> innerData = listParse(Object.class, objParse(PageResult.class, data).getData());
                    for (Object obj : innerData) {
                        convertData(obj, map);
                    }
                } else {
                    convertData(data, map);
                }
            }
        } else if (proceed instanceof PageResult) {
            Collection<Object> innerData = listParse(Object.class, objParse(PageResult.class, proceed).getData());
            for (Object obj : innerData) {
                convertData(obj, map);
            }
        } else if (proceed instanceof Collection) {
            Collection<Object> collections = listParse(Object.class, proceed);
            for (Object datum : collections) {
                convertData(datum, map);
            }
        } else {
            convertData(proceed, map);
        }
        return proceed;
    }

    public static <T> T objParse(Class<T> clazz, Object value) {
        return clazz.cast(value);
    }

    public static <T> Collection<T> listParse(Class<T> clazz, Object obj) {
        if (obj == null) {
            return Collections.emptyList();
        }
        Collection<T> result = new ArrayList<>();
        for (Object o : (Collection<?>) obj) {
            result.add(clazz.cast(o));
        }
        return result;
    }

    @SneakyThrows
    private void convertData(Object o, Map<String, Map<String, String>> map) {
        Class<?> sourceClass = o.getClass();
        for (; sourceClass != Object.class; sourceClass = sourceClass.getSuperclass()) {
            Field[] fields = sourceClass.getDeclaredFields();
            for (Field field : fields) {
                CrmDict crmDict = field.getAnnotation(CrmDict.class);
                if (crmDict == null) {
                    continue;
                }
                String typeCode = getTypeCode(crmDict, sourceClass, o);
                if (StringUtils.isEmpty(typeCode)) {
                    continue;
                }
                String dictCodeField = crmDict.dictCodeField();
                Field declaredField = sourceClass.getDeclaredField(dictCodeField);
                declaredField.setAccessible(true);
                String dictCode = null;
                if(declaredField.get(o) instanceof String){
                    dictCode = (String) declaredField.get(o);
                }
                if(declaredField.get(o) instanceof Integer){
                    dictCode = declaredField.get(o).toString();
                }
                if (StringUtils.isEmpty(dictCode)) {
                    continue;
                }
                field.setAccessible(true);
                Map<String, String> dictTypeMap = map.get(typeCode);
                if (dictTypeMap != null) {
                    String val = dictTypeMap.get(dictCode);
                    if (!StringUtils.isEmpty(val)) {
                        field.set(o, val);
                    }
                } else {
                    Map<String, String> dictMap = DictUtil.dictMap(typeCode);
                    if (dictMap != null) {
                        map.put(typeCode, dictMap);
                        String val = dictMap.get(dictCode);
                        if (!StringUtils.isEmpty(val)) {
                            field.set(o, val);
                        }
                    }
                }
            }
        }
    }

    @SneakyThrows
    private String getTypeCode(CrmDict crmDict, Class<?> sourceClass, Object o) {
        String type = crmDict.type();
        if ("1".equals(type)) {
            return crmDict.typeCode();
        } else if ("2".equals(type)) {
            String typeCode = crmDict.typeCode();
            Field typeCodeField = sourceClass.getDeclaredField(typeCode);
            typeCodeField.setAccessible(true);
            return (String) typeCodeField.get(o);
        }
        return null;
    }
}
