package com.biz.crm.dict.entity;


import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;

import java.util.Date;

/**
 * 字典明细的记录信息
 *
 * @author zxw
 */
@ApiModel(value = "DictItemVo", description = " 字典明细的记录信息")
@AllArgsConstructor
@NoArgsConstructor
@Data
@Accessors(chain = true)
public class DictItemVo {

    private String id;

    @ApiModelProperty("对应字典")
    private DictVo dictEntity;

    /**
     * 字典的值. *
     */
    @ApiModelProperty(name = "dictValue", value = "字典值", required = true)
    private String dictValue;

    /**
     * 字典的名称. *
     */
    @ApiModelProperty(name = "dictKey", value = "字典名称", required = true)
    private String dictKey;

    /**
     * 字典的排序 *
     */
    @ApiModelProperty(name = "dictSort", value = "字典排序")
    private Integer dictSort;

    /**
     * 字典明细的启用状态
     */
    @ApiModelProperty(name = "dictItemStatus", value = "字典明细的启用状态,")
    private Boolean dictItemStatus;

    /**
     * 创建时间
     */
    @ApiModelProperty(name = "createTime", value = "创建时间", required = true)
    private Date createTime;

}
