package com.biz.crm.util;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLConnection;

/**
 * @author ren.gang
 * @ClassName HoliDayUtils.java
 * @Description 节假日相关工具类
 * @createTime 2020年11月18日 17:15:00
 */
public class HoliDayUtils {


    /**
     * 根据日期判断是否法定节假日（默认从bitefu资源获取）
     *
     * @param date 日期。支持格式(yyyyMMdd、yyyy-MM-dd)
     * @return true节假日
     */
    public static boolean isHoliday(String date) {

        return isHoliday(date, SOURCE_BITEFU);
    }

    public static final String SOURCE_BITEFU = "BITEFU";

    /**
     * 根据日期判断是否法定节假日
     * @param date 日期。支持格式(yyyyMMdd、yyyy-MM-dd)
     * @param source 来源
     * @return true节假日
     */
    public static boolean isHoliday(String date, String source) {
        try {

            switch (source) {
                case SOURCE_BITEFU:
                    return getByBitefu(date);
            }

        }catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }


    private static boolean getByBitefu(String date) {
        String url = "http://tool.bitefu.net/jiari/?d=" + date;

        String result = "";
        BufferedReader in = null;
        try {
            URL realUrl = new URL(url);
            // 打开和URL之间的连接
            URLConnection connection = realUrl.openConnection();
            // 设置通用的请求属性
            connection.setRequestProperty("accept", "*/*");
            connection.setRequestProperty("connection", "Keep-Alive");
            connection.setRequestProperty("user-agent",
                    "Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.1;SV1)");
            // 建立实际的连接
            connection.connect();
            // 定义 BufferedReader输入流来读取URL的响应
            in = new BufferedReader(new InputStreamReader(
                    connection.getInputStream(), "utf-8"));
            String line;
            while ((line = in.readLine()) != null) {
                result += line;
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
        // 使用finally块来关闭输入流
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            } catch (Exception e2) {
                e2.printStackTrace();
            }
        }
        if("2".equals(result)) {
            return true;
        }

        return false;
    }
}
