package com.biz.crm.config;

import com.biz.crm.util.StringUtils;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.ResourceHandlerRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;

import java.util.ArrayList;
import java.util.List;

/**
 * @author jianglong
 * @version V1.0
 * @Package com.biz.eisp.config
 * @Description: TODO
 * @date 2019/4/11 下午4:19
 */
@Configuration
public class CrmMvcConfg implements WebMvcConfigurer {
    //spring.resources.static-locations
    @Value("${spring.resources.static-locations:}")
    private String[] resourceslocations;
    @Value("${crm.whitelist:}")
    private String[] whiteList;
    /**
     * @return
     */
    @Bean
    LoginInterceptor loginInterceptor() {
        return new LoginInterceptor();
    }

    /**
     * 添加拦截器
     *
     * @param registry
     */
    @Override
    public void addInterceptors(InterceptorRegistry registry) {
        List<String> excludeUrl = new ArrayList<>();
        if(resourceslocations!=null){
            for(String temp : this.resourceslocations){
                if(StringUtils.isNotEmpty(temp)){
                    excludeUrl.add(temp);
                }
            }
        }
        if(whiteList!=null){
            for(String temp : this.whiteList){
                if(StringUtils.isNotEmpty(temp)){
                    excludeUrl.add(temp);
                }
            }
        }
        registry.addInterceptor(loginInterceptor()).excludePathPatterns(excludeUrl);
    }

    @Override
    public void addResourceHandlers(ResourceHandlerRegistry registry) {
        // 解决静态资源无法访问
        registry.addResourceHandler("/**").addResourceLocations("classpath:/static/");
        // 解决swagger无法访问
        registry.addResourceHandler("/doc.html").addResourceLocations("classpath:/META-INF/resources/");
        // 解决swagger的js文件无法访问
        registry.addResourceHandler("/webjars/**").addResourceLocations("classpath:/META-INF/resources/webjars/");

    }
}
