package com.biz.crm.parameter.feign;

import com.biz.crm.parameter.vo.ParameterVo;
import com.biz.crm.util.Result;
import feign.hystrix.FallbackFactory;
import lombok.extern.slf4j.Slf4j;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.stereotype.Component;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

import java.util.List;

@FeignClient(url = "${feign.urlip:}", qualifier = "parameterFeign", value = "crm-mdm", path = "mdm", fallbackFactory = ParameterFeign.FallBackClass.class)
public interface ParameterFeign {

    @PostMapping("/mdmParameterController/getParameterList")
    Result<List<ParameterVo>> getParameterList(@RequestBody List<String> parameterCodeList);

    @Component
    @Slf4j
    class FallBackClass implements FallbackFactory<ParameterFeign> {
        @Override
        public ParameterFeign create(Throwable throwable) {
            return new ParameterFeign() {

                @Override
                public Result<List<ParameterVo>> getParameterList(List<String> parameterCodeList) {
                    Result<List<ParameterVo>> result = new Result<>();
                    result.error500("请求失败");
                    return result;
                }

            };
        }
    }

}
