package com.biz.crm.coderule.feign;

import com.biz.crm.util.Result;
import feign.hystrix.FallbackFactory;
import lombok.extern.slf4j.Slf4j;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.stereotype.Component;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;

/**
 * 编码生成feign接口
 *
 * @author Tao.Chen
 * @date 2020-11-05 10:47:13
 */
@FeignClient(url = "${feign.urlip:}", qualifier = "mdmCodeRuleGeneratorFeign", value = "crm-mdm", path = "mdm", fallbackFactory = MdmCodeRuleGeneratorFeign.FallBackClass.class)
public interface MdmCodeRuleGeneratorFeign {

    @PostMapping("/mdmcoderulegenerator/generateCodeList")
    Result<List<String>> generateCodeList(@RequestParam("ruleCode") String ruleCode, @RequestParam("number") Integer number);

    @Component
    @Slf4j
    class FallBackClass implements FallbackFactory<MdmCodeRuleGeneratorFeign> {
        @Override
        public MdmCodeRuleGeneratorFeign create(Throwable throwable) {
            return new MdmCodeRuleGeneratorFeign() {
                @Override
                public Result<List<String>> generateCodeList(String ruleCode, Integer number) {
                    log.error("编码生成失败:{}",throwable);
                    Result<List<String>> result = new Result<>();
                    result.error500("请求失败");
                    return result;
                }
            };
        }
    }
}
