package com.biz.crm.exception.tpm;

import com.biz.crm.exception.CrmExceptionType;

/**
 * @Project crm
 * @PackageName com.biz.crm.exception.tpm
 * @ClassName AuditCollectExampleException
 * @Author HuangLong
 * @Date 2020/9/2 11:04
 * @Description 核销采集示例异常枚举
 */
public enum AuditCollectExampleException implements CrmExceptionType {

    DATA_NOT_EXIST("tpm_30001","核销采集示例数据不存在"),
    DATA_DUPLICATE("tpm_30002","核销采集示例数据重复,请检查"),
    ;

    private String code;
    private String description;

    AuditCollectExampleException(String code, String description) {
        this.code = code;
        this.description = description;
    }

    @Override
    public String getCode() {
        return code;
    }

    @Override
    public String getDescription() {
        return description;
    }
}
