package com.biz.crm.util;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLConnection;
import java.time.LocalDate;
import java.util.HashMap;
import java.util.Map;

/**
 * @author ren.gang
 * @ClassName HoliDayUtils.java
 * @Description 节假日相关工具类
 * @createTime 2020年11月18日 17:15:00
 */
public class HoliDayUtils {


    /**
     * 根据日期判断是否法定节假日（默认从bitefu资源获取）
     *
     * @param date 日期。支持格式(yyyyMMdd、yyyy-MM-dd)
     * @return true节假日
     */
    public static boolean isHoliday(String date) {

        return isHoliday(date, SOURCE_TIANXING);
    }

    public static final String SOURCE_BITEFU = "BITEFU";
    // 天行数据接口，需要注册
    public static final String SOURCE_TIANXING = "TIANXING";

    /**
     * 根据日期判断是否法定节假日
     * @param date 日期。支持格式(yyyyMMdd、yyyy-MM-dd)
     * @param source 来源
     * @return true节假日
     */
    public static boolean isHoliday(String date, String source) {
        try {

            switch (source) {
                case SOURCE_BITEFU:
                    return checkByBitefu(date);
                case SOURCE_TIANXING:
                    return checkByTianxing(date);
            }

        }catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }


    /**
     * 天行数据接口，缓存至内存中
     * @param date
     * @return
     */
    private static final String TIANXIN_URL = "http://api.tianapi.com/txapi/jiejiari/index?key=37a71f7809c31067bd9c585b4382ae9e&type=1&date=";
    private static String toDay=null;
    private static Map<String, String> holidayMap = null;
    public static boolean checkByTianxing(String date) {
        LocalDate localDate = LocalDate.now();
        String year = LocalDate.parse(date).getYear()+"";
        // 缓存当日节假日数据
        if(!localDate.toString().equals(toDay)) {
            toDay = localDate.toString();
            holidayMap = new HashMap<>();
        }
        if(StringUtils.isEmpty(holidayMap.get(year))) {
            holidayMap.put(year, getByUrl(TIANXIN_URL + year));
        }
        if(holidayMap.get(year).indexOf(date) > -1) {
            return true;
        } else {
            return false;
        }
    }


    /**
     *
     * @param date
     * @return
     */
    private static final String BITEFU_URL = "http://tool.bitefu.net/jiari/?d=";
    public static boolean checkByBitefu(String date) {
        String result = getByUrl(BITEFU_URL + date);
        try {
            if (Integer.parseInt(result) > 0) {
                return true;
            }
        }catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }

    /**
     * 获取请求数据
     * @param url
     * @return
     */
    private static String getByUrl(String url) {
        String result = "";
        BufferedReader in = null;
        try {
            URL realUrl = new URL(url);
            // 打开和URL之间的连接
            URLConnection connection = realUrl.openConnection();
            // 设置通用的请求属性
            connection.setRequestProperty("accept", "*/*");
            connection.setRequestProperty("connection", "Keep-Alive");
            connection.setRequestProperty("user-agent",
                    "Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.1;SV1)");
            // 建立实际的连接
            connection.connect();
            // 定义 BufferedReader输入流来读取URL的响应
            in = new BufferedReader(new InputStreamReader(
                    connection.getInputStream(), "utf-8"));
            String line;
            while ((line = in.readLine()) != null) {
                result += line;
            }
        } catch (Exception e) {
            e.printStackTrace();
        } finally { // 使用finally块来关闭输入流
            try {
                if (in != null) {
                    in.close();
                }
            } catch (Exception e2) {
                e2.printStackTrace();
            }
        }
        return result;
    }
}
