package com.biz.crm.base;

import com.biz.crm.eunm.LanguageTypeEnum;
import com.biz.crm.exception.CrmExceptionType;
import com.biz.crm.util.MsgTranslateUtil;
import lombok.Getter;
import lombok.Setter;
import lombok.ToString;

/**
 * @Author zhangyuzhu
 * @Description 自定义运行时异常
 * @Created data 2018/7/13 10:38
 */
@Getter
@Setter
@ToString
public class BusinessException extends RuntimeException {

    /** 错误原因code*/
    private Integer code;
    /** 错误原因*/
    private String msg;


    public BusinessException() {
        super();
    }


    public BusinessException(String msg){
        super(msg);
        this.msg = msg;
    }

    public BusinessException msg(String msg){
        this.msg = msg;
        return this;
    }

    public BusinessException(Integer code, String msg){
        super(new StringBuffer(code).append(":").append(msg).toString());
        this.msg = msg;
        this.code = code;
    }

    public BusinessException(String msg, Throwable t){
        super(msg,t);
        this.msg = msg;
    }

    public BusinessException(CrmExceptionType exceptionType){
        super(MsgTranslateUtil.convert(exceptionType.getCode(),exceptionType.getDescription(), LanguageTypeEnum.CHINA));
        this.msg = exceptionType.getDescription();
    }

    public BusinessException(Integer code, String msg, Throwable t) {
        super(new StringBuffer(code).append(":").append(msg).toString(),t);
        this.code = code;
        this.msg = msg;
    }
}
