package com.biz.crm.eunm.sfa;

import java.util.HashMap;
import java.util.Map;

/**
 * @Description:
 * @project：crm
 * @package：com.biz.crm.enums
 * @author：lifei
 * @create：2020/11/27 11:13 上午
 */
public class SfaCodeEnum {

    /**
     * 公告编码
     */
    public enum NoticeCode {
        SFA_NOTICE_CODE("sfa_notice","公告编码"),
        ;
        private String val;
        private String desc;

        NoticeCode(String val, String desc) {
            this.val = val;
            this.desc = desc;
        }

        public static Map<String, String> GETMAP = new HashMap<>();

        static {
            for (SfaVisitEnum.visitType type : SfaVisitEnum.visitType.values()) {
                GETMAP.put(type.getVal(), type.getDesc());
            }
        }

        public String getVal() {
            return val;
        }

        public void setVal(String val) {
            this.val = val;
        }

        public String getDesc() {
            return desc;
        }

        public void setDesc(String desc) {
            this.desc = desc;
        }
    }

    /**
     * 拜访步骤编码
     */
    public enum VisitStepCode {
        SFA_VISIT_STEP_CODE("sfa_visit_step","拜访步骤编码"),
        ;
        private String val;
        private String desc;

        VisitStepCode(String val, String desc) {
            this.val = val;
            this.desc = desc;
        }

        public static Map<String, String> GETMAP = new HashMap<>();

        static {
            for (SfaVisitEnum.visitType type : SfaVisitEnum.visitType.values()) {
                GETMAP.put(type.getVal(), type.getDesc());
            }
        }

        public String getVal() {
            return val;
        }

        public void setVal(String val) {
            this.val = val;
        }

        public String getDesc() {
            return desc;
        }

        public void setDesc(String desc) {
            this.desc = desc;
        }
    }


    /**
     * 线路组编码
     */
    public enum VisitGroupCode {
        SFA_VISIT_GROUP_CODE("sfa_visit_group","线路组编码"),
        ;
        private String val;
        private String desc;

        VisitGroupCode(String val, String desc) {
            this.val = val;
            this.desc = desc;
        }

        public static Map<String, String> GETMAP = new HashMap<>();

        static {
            for (SfaVisitEnum.visitType type : SfaVisitEnum.visitType.values()) {
                GETMAP.put(type.getVal(), type.getDesc());
            }
        }

        public String getVal() {
            return val;
        }

        public void setVal(String val) {
            this.val = val;
        }

        public String getDesc() {
            return desc;
        }

        public void setDesc(String desc) {
            this.desc = desc;
        }
    }


    /**
     * 拜访计划编码
     */
    public enum VisitPLanCode {
        SFA_VISIT_LINE_CODE("sfa_visit_line_code","线路组拜访计划编码"),
        SFA_VISIT_OUTLETS_CODE("sfa_visit_outlets_code","网点拜访计划编码"),
        SFA_VISIT_RATE_CODE("sfa_visit_rate_code","频率拜访计划编码"),
        ;
        private String val;
        private String desc;

        VisitPLanCode(String val, String desc) {
            this.val = val;
            this.desc = desc;
        }

        public static Map<String, String> GETMAP = new HashMap<>();

        static {
            for (SfaVisitEnum.visitType type : SfaVisitEnum.visitType.values()) {
                GETMAP.put(type.getVal(), type.getDesc());
            }
        }

        public String getVal() {
            return val;
        }

        public void setVal(String val) {
            this.val = val;
        }

        public String getDesc() {
            return desc;
        }

        public void setDesc(String desc) {
            this.desc = desc;
        }
    }

}
