package com.biz.crm.exception.tpm;

import com.biz.crm.exception.CrmExceptionType;

/**
 * @Project crm
 * @PackageName com.biz.crm.exception.tpm
 * @ClassName FiscalYearSettingException
 * @Author HuangLong
 * @Date 2020/9/2 11:04
 * @Description 财年设置异常枚举
 */
public enum FiscalYearSettingException implements CrmExceptionType {

    DATA_NOT_EXIST("tpm_10001","财年设置数据不存在"),
    DATA_DUPLICATE("tpm_10002","财年设置数据重复,请检查"),
    ;

    private String code;
    private String description;

    FiscalYearSettingException(String code, String description) {
        this.code = code;
        this.description = description;
    }

    @Override
    public String getCode() {
        return code;
    }

    @Override
    public String getDescription() {
        return description;
    }
}
