package com.biz.crm.eunm.sfa;

import jodd.util.StringUtil;

import java.util.HashMap;
import java.util.Map;

/**
 * @Description:sfa     公共常量
 * @Author: liuhongming
 * @Date: 2020/9/21 18:25
 **/
public class SfaCommonEnum {
    /**
     * 范围类型
     */
    public enum rangeTypeEnum {
        One("1","包含"),
        Two("2","非包含");
        private String val;
        private String desc;

        rangeTypeEnum(String val,String desc) {
            this.val = val;
            this.desc = desc;
        }

        public String getVal() {
            return val;
        }

        public void setVal(String val) {
            this.val = val;
        }

        public String getDesc() {
            return desc;
        }

        public void setDesc(String desc) {
            this.desc = desc;
        }
    }

    /**
     * 范围数据类型
     */
    public enum dataTypeEnum {
        channel("1","渠道"),
        org("2","组织"),
        cust("3","客户");
        private String val;
        private String desc;

        dataTypeEnum(String val,String desc) {
            this.val = val;
            this.desc = desc;
        }

        public String getVal() {
            return val;
        }

        public void setVal(String val) {
            this.val = val;
        }

        public String getDesc() {
            return desc;
        }

        public void setDesc(String desc) {
            this.desc = desc;
        }
    }

    public enum clientTypeEnum {
        cust("01","经销商"),
        term("02","终端");
        private String val;
        private String desc;

        clientTypeEnum(String val,String desc) {
            this.val = val;
            this.desc = desc;
        }

        public String getVal() {
            return val;
        }

        public void setVal(String val) {
            this.val = val;
        }

        public String getDesc() {
            return desc;
        }

        public void setDesc(String desc) {
            this.desc = desc;
        }
    }

    /**
     * 请假类型
     */
    public enum leaveTypeEnum {
        ANNUAL_LEAVE("001", "年假")
        ,PERSONAL_LEAVE("002", "事假")
        ,MARRIAGE_LEAVE("003", "婚假")
        ,FUNERAL_LEAVE("004", "丧假")
        ,PATERNITY_LEAVE("005", "陪产假")
        ,DAYS_OFF("006", "调休")
        ,SICK_LEAVE("007", "病假")
        ,MATERNITY_LEAVE("008", "产假")
        ;

        /** 查询描述信息 */
        public static String getDesc(String val) {
            for(SfaCommonEnum.leaveTypeEnum e : SfaCommonEnum.leaveTypeEnum.values()) {
                if(e.getVal().equals(val)) {
                        return e.getDesc();
                }
            }
            return null;
        }
        private String val;
        private String desc;
        leaveTypeEnum(String val, String desc) {
            this.val = val;
            this.desc = desc;
        }
        public String getVal() {
            return val;
        }
        public String getDesc() {
            return desc;
        }
    }


    /**
     * 审批类型
     */
    public enum businessType {
        leave("0", "请假申请"),
        travel("1", "出差申请");

        private String value;
        private String desc;


        businessType(String value, String desc) {
            this.value = value;
            this.desc = desc;
        }

        static Map<String, SfaCommonEnum.businessType> enumMap = new HashMap<>();
        public static String REPLACE = "";

        static {
            for (SfaCommonEnum.businessType type : SfaCommonEnum.businessType.values()) {
                enumMap.put(type.getValue(), type);
                if (StringUtil.isNotEmpty(REPLACE)) {
                    REPLACE += ",";
                }
                REPLACE += type.getDesc() + "_" + type.getValue();
            }
        }

        public String getValue() {
            return value;
        }

        public Integer getIntValue() {
            return Integer.valueOf(value);
        }

        public void setValue(String value) {
            this.value = value;
        }

        public String getDesc() {
            return desc;
        }

        public void setDesc(String desc) {
            this.desc = desc;
        }

        public static Map<String, SfaCommonEnum.businessType> getEnumMap() {
            return enumMap;
        }

        public static String getTheDescBuVal(String val) {
            return enumMap.containsKey(val) ? enumMap.get(val).getDesc() : "";
        }


        public static String replaceStr() {
            SfaCommonEnum.businessType[] dataDownTypes = SfaCommonEnum.businessType.values();
            String str = "";
            for (int i = 0; i < dataDownTypes.length; i++) {
                str += dataDownTypes[i].desc + "_" + dataDownTypes[i].value;
                if (i != dataDownTypes.length - 1) {
                    str += ",";
                }
            }
            return str;
        }

    }


    /**
     * 请假加班审批状态
     */
    public enum dataBpmStatus {
        COMMIT("1", "已提交"),
        APPROVAL("2", "审批中"),
        PASS("3", "审批通过"),
        REJECT("4", "审批驳回"),
        ROLLBACK("5", "追回");


        private String value;
        private String desc;

        /** 查询描述信息 */
        public static String getDesc(String val) {
            for(SfaCommonEnum.dataBpmStatus e : SfaCommonEnum.dataBpmStatus.values()) {
                if(e.getValue().equals(val)) {
                    if(val.equals(COMMIT.getValue()) || val.equals(APPROVAL.getValue())) {
                        return APPROVAL.getDesc();
                    } else {
                        return e.getDesc();
                    }
                }
            }
            return null;
        }

        dataBpmStatus(String value, String desc) {
            this.value = value;
            this.desc = desc;
        }

        static Map<String, SfaCommonEnum.dataBpmStatus> enumMap = new HashMap<>();
        public static String REPLACE = "";

        static {
            for (SfaCommonEnum.dataBpmStatus type : SfaCommonEnum.dataBpmStatus.values()) {
                enumMap.put(type.getValue(), type);
                if (StringUtil.isNotEmpty(REPLACE)) {
                    REPLACE += ",";
                }
                REPLACE += type.getDesc() + "_" + type.getValue();
            }
        }

        public String getValue() {
            return value;
        }

        public Integer getIntValue() {
            return Integer.valueOf(value);
        }

        public void setValue(String value) {
            this.value = value;
        }

        public String getDesc() {
            return desc;
        }

        public void setDesc(String desc) {
            this.desc = desc;
        }

        public static Map<String, SfaCommonEnum.dataBpmStatus> getEnumMap() {
            return enumMap;
        }

        public static String getTheDescBuVal(String val) {
            return enumMap.containsKey(val) ? enumMap.get(val).getDesc() : "";
        }


        public static String replaceStr() {
            SfaCommonEnum.dataBpmStatus[] dataDownTypes = SfaCommonEnum.dataBpmStatus.values();
            String str = "";
            for (int i = 0; i < dataDownTypes.length; i++) {
                str += dataDownTypes[i].desc + "_" + dataDownTypes[i].value;
                if (i != dataDownTypes.length - 1) {
                    str += ",";
                }
            }
            return str;
        }

    }


    /**
     * 请假申请-日期详情类型
     */
    public enum dataTimeType {
        ALL_DAY("1", "全天"),
        FORENOON("2", "上午"),
        AFTERNOON("3", "下午");

        private String value;
        private String desc;

        dataTimeType(String value, String desc) {
            this.value = value;
            this.desc = desc;
        }

        public String getValue() {
            return value;
        }

        public String getDesc() {
            return desc;
        }
    }


    /**
     * 请假加班审批状态
     */
    public enum apiBpmStatus {
        COMMIT("1", "待审批"),
        PASS("2", "审批通过"),
        REJECT("3", "审批驳回");

        private String value;
        private String desc;


        apiBpmStatus(String value, String desc) {
            this.value = value;
            this.desc = desc;
        }

        static Map<String, SfaCommonEnum.apiBpmStatus> enumMap = new HashMap<>();
        public static String REPLACE = "";

        static {
            for (SfaCommonEnum.apiBpmStatus type : SfaCommonEnum.apiBpmStatus.values()) {
                enumMap.put(type.getValue(), type);
                if (StringUtil.isNotEmpty(REPLACE)) {
                    REPLACE += ",";
                }
                REPLACE += type.getDesc() + "_" + type.getValue();
            }
        }

        public String getValue() {
            return value;
        }

        public Integer getIntValue() {
            return Integer.valueOf(value);
        }

        public void setValue(String value) {
            this.value = value;
        }

        public String getDesc() {
            return desc;
        }

        public void setDesc(String desc) {
            this.desc = desc;
        }

        public static Map<String, SfaCommonEnum.apiBpmStatus> getEnumMap() {
            return enumMap;
        }

        public static String getTheDescBuVal(String val) {
            return enumMap.containsKey(val) ? enumMap.get(val).getDesc() : "";
        }


        public static String replaceStr() {
            SfaCommonEnum.apiBpmStatus[] dataDownTypes = SfaCommonEnum.apiBpmStatus.values();
            String str = "";
            for (int i = 0; i < dataDownTypes.length; i++) {
                str += dataDownTypes[i].desc + "_" + dataDownTypes[i].value;
                if (i != dataDownTypes.length - 1) {
                    str += ",";
                }
            }
            return str;
        }

    }




}
