package com.biz.crm.eunm.upload;

import java.util.HashMap;
import java.util.Map;

/**
 * @Description:
 * @project：crm
 * @package：com.biz.crm.eunm.upload
 * @author：lifei
 * @create：2020/12/9 1:37 下午
 */
public class UploadEnum {

    /**
     * 文件状态
     */
    public enum fileStatus{
        FAIL("0","失败"),
        SUCCESS("1","成功"),
        IN_EXECUTION("2","执行中"),
        ;
        private String val;
        private String desc;

        fileStatus(String val, String desc) {
            this.val = val;
            this.desc = desc;
        }

        public static Map<String, String> GETMAP = new HashMap<>();

        static {
            for (fileStatus type : fileStatus.values()) {
                GETMAP.put(type.getVal(), type.getDesc());
            }
        }

        public String getVal() {
            return val;
        }

        public void setVal(String val) {
            this.val = val;
        }

        public String getDesc() {
            return desc;
        }

        public void setDesc(String desc) {
            this.desc = desc;
        }


    }

    public enum fileType{
        EXPORT("1","导出"),
        IMPORT("0","导入"),

        ;
        private String val;
        private String desc;

        fileType(String val, String desc) {
            this.val = val;
            this.desc = desc;
        }

        public static Map<String, String> GETMAP = new HashMap<>();

        static {
            for (fileType type : fileType.values()) {
                GETMAP.put(type.getVal(), type.getDesc());
            }
        }

        public String getVal() {
            return val;
        }

        public void setVal(String val) {
            this.val = val;
        }

        public String getDesc() {
            return desc;
        }

        public void setDesc(String desc) {
            this.desc = desc;
        }


    }
}
