package com.biz.crm.eunm.job;

import com.biz.crm.eunm.activiti.Indicator;

import java.util.LinkedHashMap;
import java.util.Map;

/**
 * Created by weston on 2017/5/7.
 */
public enum JobColumn {

    //任务状态
    TRIGGER_STATUS(JobIndicator.TRIGGER_STATUS_STOP,JobIndicator.TRIGGER_STATUS_START);
    private Map<Integer, String> maps = new LinkedHashMap<>();

    /**
     *
     * @param values
     */
    JobColumn(JobIndicator... values) {
        for (JobIndicator it : values) {
            maps.put(it.getCode(), it.getLabel());
        }
    }

    public String getLabelByCode(Integer code) {
        if (code == null) {
            return null;
        } else {
            return maps.get(code);
        }
    }


    public Map<Integer, String> getCodesAndLabels() {
        return maps;
    }

}
