package com.biz.crm.eunm;

import java.util.HashSet;
import java.util.Set;

/**
 * @Description:语言类型
 * @Author: huanglong
 * @Date: 2020/8/20 18:25
 **/
public enum LanguageTypeEnum {
    CHINA("china","中文"),
    JAPAN("japan","日文");

    private String code;
    private String des;

    LanguageTypeEnum(String code, String des) {
        this.code = code;
        this.des = des;
    }

    public String getCode() {
        return code;
    }

    public String getDes() {
        return des;
    }

    /**
     * code转数组
     * @return
     */
    public static Set<String> codeToSet(){
        Set<String> codes = new HashSet<>();
        for (LanguageTypeEnum productTypeEnum : LanguageTypeEnum.values()) {
            codes.add(productTypeEnum.getCode());
        }
        return codes;
    }
}
