package com.biz.crm.eunm.activiti;

public enum Indicator {

    // 通用状态
    VALID_IND_YES(1, "有效"), VALID_IND_NO(2, "无效"),
    // 流程发布状态
    PROCESS_STATE_EDIT(0, "未发布"), PROCESS_STATE_DEPLOY(1, "已发布"),
    //流程使用状态
    PROCESS_STATUS_NORMAL(0, "正常"), PROCESS_STATUS_DELETE(1, "已删除"),
    // 节点类型
    TASK_TYPE_HIS(1, "历史节点"), TASK_TYPE_RUN(2, "待办节点"), TASK_TYPE_COPY(3, "抄送节点"),
    // 通用性别
    COMMON_SEX_MAN(1, "男"), COMMON_SEX_WOMAN(2, "女"),
    // 通用是否
    COMMON_YES(1, "是"), COMMON_NO(2, "否"),
    // 通用启用/禁用状态
    COMMON_ENABLE(1, "启用"), COMMON_DISABLE(0, "禁用"),
    // 抄送节点状态
    COPY_TASK_STATUS_UNREAD(1, "未读"), COPY_TASK_STATUS_READ(2, "已阅"),
    //监听器类型
    LISTENER_TYPE_EXEC(1, "执行监听器"), LISTENER_TYPE_WORK(2, "任务监听器"),

    // 流程实例基础对象的状态
    ACT_BASE_STATUS_DRAFT(0, "草稿"), ACT_BASE_STATUS_SAVE(1, "暂存待办"),

    ACT_BASE_STATUS_DOING(2, "审批中"),

    ACT_BASE_STATUS_FINISH(3, "已完成"), ACT_BASE_STATUS_REJECT(4, "驳回"),

    ACT_BASE_STATUS_END(5, "终止"),

    ACT_BASE_STATUS_CANCEL(6, "已撤销"), ACT_BASE_STATUS_RESTART(7, "已发起新流程"),

    ACT_BASE_STATUS_STOP(8, "关闭"),

    // 流程节点的类型
    NODE_TYPE_COMMON(0, "普通流程节点"), NODE_TYPE_ADD_SIGN(1, "加签节点"),

    NODE_TYPE_FORWARD(2, "转发节点"),

    // 流程产生原因类型
    PROCESS_CAUSE_TYPE_COMMON(1, "普通发起"), PROCESS_CAUSE_TYPE_REJECT(2, "驳回"),

    PROCESS_CAUSE_TYPE_FORWARD(3, "转发"),

    PROCESS_CAUSE_TYPE_ADD(4, "加签"), PROCESS_CAUSE_TYPE_CHILD(5, "子流程"),

    // 是否葡萄酒
    PRODUCT_WINE_TRUE(1, "是"), PRODUCT_WINE_FALSE(2, "否"),

    // 重复是否跳过
    REPEAT_SKIP_FALSE(0, "否"), REPEAT_SKIP_TRUE(1, "是"),

    // 为空是否跳过
    NULL_SKIP_FALSE(0, "否"), NULL_SKIP_TRUE(1, "是"),

    // 消息是否已读
    MSG_READ_YES(1, "已读"), MSG_READ_NO(0, "未读"),

    //费用表单状态
    COST_FORM_STATUS_APPROVING(10, "审批中"), COST_FORM_STATUS_APPROVED(15, "已审核"),

    COST_FORM_STATUS_USING(20, "部分已使用"), COST_FORM_STATUS_USED(25, "完全使用"),

    COST_FORM_STATUS_CLOSED(30, "关闭"), COST_FORM_STATUS_INTERRUPT(31, "中断"),

    COST_FORM_STATUS_SAVE(35, "未提交"),

    COST_FORM_STATUS_SUBMIT_FAIL(40, "提交失败"), COST_FORM_STATUS_REJECT(45, "撤回修改"),

    COST_FORM_STATUS_RESUBMIT(46, "驳回后发起"), COST_FORM_STATUS_CANCEL(50, "废弃"),

    //dms表单状态
    CON_BPM_NEW(1, "待提交"), CON_BPM_DOING(2, "审核中"),

    CON_BPM_PASS(3, "已驳回"), CON_BPM_ABORT(4, "已审核"),

    CON_BPM_REJECT(5, "撤销"),

    CON_BPM_SAVE(100, "暂存"),

    //fico表单回退标识
    FICO_TURN_BACK(99, "回退标识"),

    // 是否忽略空
    IGNORE_NULL_ONLY_YES(0, "仅忽略"), IGNORE_NULL_NO(1, "不忽略并报告"),

    IGNORE_NULL_PASS(2, "忽略并跳过"),

    //是否允许回退
    CAN_BACK_YES(1, "是"), CAN_BACK_NO(0, "否"),

    //内部节点配置：是否知会
    INSIDE_NOTICE_YES(1, "是"), INSIDE_NOTICE_NO(0, "不是"),

    // 尋崗方式
    QUERY_POS_TYPE_COMMON(0, "用角色寻岗"), QUERY_POS_TYPE_ORG(1, "角色岗位配置寻岗"),

    QUERY_POS_TYPE_ORG_UN(2, "角色排除寻岗"),

    QUERY_POS_DEPART_APPROVE(3, "直接负责人寻岗"), QUERY_POS_DEPART_ADMIN(4, "指定科室负责人寻岗"),

    QUERY_POS_SPECIAL_CONFIG(5, "特殊审批配置寻岗"),

    // 并行方式
    PARALLEL_STYLE_NOT(0, "常规"), PARALLEL_STYLE_GROUP(1, "同步"),

    PARALLEL_STYLE_ONLY(2, "互斥"),

    PARALLEL_STYLE_COMPETE(3, "竞争"),

    // 审批类型
    APPROVE_TYPE_COMMON(0, "普通"), APPROVE_TYPE_FINISH(1, "最终审批"),

    APPROVE_TYPE_AUDIT(2, "审核"), APPROVE_TYPE_RE(3, "复核"),

    APPROVE_TYPE_FI(4, "财务审批"), APPROVE_TYPE_CHARGE(5, "负责人审批"),

    TICKET_TYPE_NEW(1, "创建"), TICKET_TYPE_ROLL_BACK(2, "回滚"),

    TICKET_TYPE_STOP(3, "终止"),

    TICKET_STATUS_INIT(0, "初始"), TICKET_STATUS_FINISH(1, "完成"),

    TICKET_STATUS_ERROR(2, "异常"),

    // 平均分配的查询类型
    AVERAGE_FIND_TYPE_COMMON(0, "普通平均"), AVERAGE_FIND_TYPE_ORG(1, "按科室平均"),

    //流程实例状态
    AVAILABLE_STATUS_START(1, "启用"), AVAILABLE_STATUS_STOP(2, "暂停"),
    AVAILABLE_STATUS_FINISH(3, "结束"), AVAILABLE_STATUS_CANCEL(4, "关闭");


    private int code;

    private String label;

    Indicator(int code, String label) {
        this.code = code;
        this.label = label;
    }

    public int getCode() {
        return code;
    }

    public String getLabel() {
        return label;
    }

}
