package com.biz.crm.util;

import com.biz.crm.base.config.ThreadLocalUtil;
import com.biz.crm.common.param.RedisParam;
import com.biz.crm.mdm.org.MdmOrgRedisFeign;
import com.biz.crm.nebular.mdm.org.resp.MdmOrgRedisVo;
import com.biz.crm.nebular.mdm.org.resp.MdmOrgRespVo;
import com.biz.crm.service.RedisService;
import lombok.extern.slf4j.Slf4j;

import java.util.*;
import java.util.stream.Collectors;

@Slf4j
@Deprecated
public class OrgUtil {

    private static RedisService redisService;

    private static MdmOrgRedisFeign mdmOrgRedisFeign;

    public static void setRedisService(RedisService redis) {
        redisService = redis;
    }

    public static void setMdmOrgRedisFeign(MdmOrgRedisFeign orgRedisFeign) {
        mdmOrgRedisFeign = orgRedisFeign;
    }

    public static MdmOrgRespVo getOrgByCode(String orgCode) {
        if (orgCode != null && !"".equals(orgCode)) {
            Map<String, MdmOrgRedisVo> orgRedisMap = getOrgSelfRedisMapFromLocalFirst(Collections.singletonList(orgCode));
            if (orgRedisMap.containsKey(orgCode)) {
                MdmOrgRedisVo mdmOrgRedisVo = orgRedisMap.get(orgCode);
                return CrmBeanUtil.copy(mdmOrgRedisVo, MdmOrgRespVo.class);
            }
        }
        return null;
    }

    public static List<MdmOrgRespVo> getOrgByCodeList(List<String> orgCodeList) {
        List<MdmOrgRespVo> list = new ArrayList<>();
        if (orgCodeList != null && orgCodeList.size() > 0) {
            Map<String, MdmOrgRedisVo> orgRedisMap = getOrgSelfRedisMapFromLocalFirst(orgCodeList);
            if (!orgRedisMap.isEmpty()) {
                list.addAll(orgRedisMap.values().stream().map(item -> CrmBeanUtil.copy(item, MdmOrgRespVo.class)).collect(Collectors.toList()));
            }
        }
        return list;
    }

    private static Map<String, MdmOrgRedisVo> getOrgSelfRedisMapFromLocalFirst(List<String> orgCodeList) {
        Map<String, MdmOrgRedisVo> map = new HashMap<>(16);
        try {
            if (orgCodeList != null && orgCodeList.size() > 0) {

                Set<String> getFromRedisCodeSet = new HashSet<>(16);
                for (String orgCode :
                        orgCodeList) {
                    if (ThreadLocalUtil.orgSelfContains(orgCode)) {
                        MdmOrgRedisVo fromOrgSelf = ThreadLocalUtil.getFromOrgSelf(orgCode);
                        map.put(orgCode, fromOrgSelf);
                    } else {
                        getFromRedisCodeSet.add(orgCode);
                    }
                }

                if (!getFromRedisCodeSet.isEmpty()) {
                    Map<String, MdmOrgRedisVo> mapFromRedisFirst = getOrgSelfRedisMapFromRedisFirst(new ArrayList<>(orgCodeList));

                    for (String orgCode :
                            getFromRedisCodeSet) {
                        if (mapFromRedisFirst.containsKey(orgCode)) {
                            map.put(orgCode, mapFromRedisFirst.get(orgCode));
                        }
                        ThreadLocalUtil.addToOrgSelf(orgCode, mapFromRedisFirst.get(orgCode));
                    }
                }
            }
        } catch (Exception e) {
            log.error("组织查询工具类异常：{}", e);
        }
        return map;
    }

    private static Map<String, MdmOrgRedisVo> getOrgSelfRedisMapFromRedisFirst(List<String> orgCodeList) {
        Map<String, MdmOrgRedisVo> map = new HashMap<>(16);
        try {
            if (orgCodeList != null && orgCodeList.size() > 0) {
                List<MdmOrgRedisVo> redisVoList = new ArrayList<>();
                Set<String> lockCodeList = new HashSet<>(16);
                List<Object> lockListFromHash = redisService.hmget(RedisParam.MDM_ORG_LOCK_HASH, new HashSet<Object>(orgCodeList));
                if (lockListFromHash != null && lockListFromHash.size() > 0) {
                    lockCodeList.addAll(lockListFromHash.stream().filter(Objects::nonNull).map(Object::toString).collect(Collectors.toSet()));
                }
                Set<String> notLockGetFromRedisCodeSet = orgCodeList.stream().filter(item -> !lockCodeList.contains(item)).collect(Collectors.toSet());
                Set<String> redisHasCodeSet = new HashSet<>(16);
                if (!notLockGetFromRedisCodeSet.isEmpty()) {
                    List<Object> orgListFromRedis = redisService.hmget(RedisParam.MDM_ORG_SELF_HASH, new HashSet<Object>(notLockGetFromRedisCodeSet));
                    if (orgListFromRedis != null && orgListFromRedis.size() > 0) {
                        List<MdmOrgRedisVo> collect = orgListFromRedis.stream().filter(Objects::nonNull).map(item -> CrmBeanUtil.copy(item, MdmOrgRedisVo.class)).collect(Collectors.toList());
                        if (collect.size() > 0) {
                            redisVoList.addAll(collect);
                            redisHasCodeSet.addAll(collect.stream().map(MdmOrgRedisVo::getOrgCode).collect(Collectors.toSet()));
                        }
                    }
                }

                Set<String> getByFeignCodeSet = notLockGetFromRedisCodeSet.stream().filter(item -> !redisHasCodeSet.contains(item)).collect(Collectors.toSet());
                if (!getByFeignCodeSet.isEmpty()) {
                    Result<List<MdmOrgRedisVo>> result = mdmOrgRedisFeign.findRedisListByOrgCodeList(new ArrayList<>(getByFeignCodeSet));
                    if (result.isSuccess()) {
                        Map<String, String> lockCodeMap = new HashMap<>(16);
                        List<MdmOrgRedisVo> list = result.getResult();
                        if (list != null && list.size() > 0) {
                            Map<String, MdmOrgRedisVo> collect = list.stream().collect(Collectors.toMap(MdmOrgRedisVo::getOrgCode, v -> v));

                            Map<String, MdmOrgRedisVo> cacheMap = new HashMap<>(16);
                            for (String orgCode :
                                    getByFeignCodeSet) {
                                if (!collect.containsKey(orgCode)) {
                                    lockCodeMap.put(orgCode, orgCode);
                                } else {
                                    redisVoList.add(collect.get(orgCode));
                                    cacheMap.put(orgCode, collect.get(orgCode));
                                }
                            }
                            if (!cacheMap.isEmpty()) {
                                redisService.hmset(RedisParam.MDM_ORG_SELF_HASH, new HashMap<Object, Object>(cacheMap));
                            }
                        } else {
                            lockCodeMap.putAll(getByFeignCodeSet.stream().collect(Collectors.toMap(k -> k, v -> v)));
                        }
                        if (!lockCodeMap.isEmpty()) {
                            redisService.hmset(RedisParam.MDM_ORG_LOCK_HASH, new HashMap<Object, Object>(lockCodeMap), RedisParam.TIME30);
                        }
                    }
                }
                if (redisVoList.size() > 0) {
                    map.putAll(redisVoList.stream().collect(Collectors.toMap(MdmOrgRedisVo::getOrgCode, v -> v)));
                }
            }
        } catch (Exception e) {
            log.error("组织查询工具类异常：{}", e);
        }
        return map;
    }

    public static void deleteAllCache() {

        Map<Object, Object> lockHash = redisService.hmget(RedisParam.MDM_ORG_LOCK_HASH);
        if (!lockHash.isEmpty()) {
            redisService.hdel(RedisParam.MDM_ORG_LOCK_HASH, lockHash.keySet().toArray());
        }

        Map<Object, Object> selfHash = redisService.hmget(RedisParam.MDM_ORG_SELF_HASH);
        if (!selfHash.isEmpty()) {
            redisService.hdel(RedisParam.MDM_ORG_SELF_HASH, selfHash.keySet().toArray());
        }

    }


}
