package com.biz.crm.exception.tpm;

import com.biz.crm.exception.CrmExceptionType;

/**
 * 核销异常枚举
 * @author zeyi
 */
public enum AuditException implements CrmExceptionType {

    DATA_NOT_EXIST("tpm_90001","核销数据不存在"),
    DATA_DUPLICATE("tpm_90002","核销数据重复,请检查"),
    DATA_CODE_DUPLICATE("tpm_90003","核销编码已存在,请检查"),
    ;

    private String code;
    private String description;

    AuditException(String code, String description) {
        this.code = code;
        this.description = description;
    }

    @Override
    public String getCode() {
        return code;
    }

    @Override
    public String getDescription() {
        return description;
    }
}
