package com.biz.crm.config;

import com.biz.crm.common.GlobalParam;
import com.biz.crm.service.RedisService;
import com.biz.crm.util.CookiesUtil;
import com.biz.crm.util.StringUtils;
import com.biz.crm.util.UserRedis;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.stereotype.Component;
import org.springframework.web.filter.OncePerRequestFilter;

import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.ArrayList;

/**
 * @author jianglong
 * @version V1.0
 * @Package com.biz.crm.config
 * @Description: TODO
 * @date 2020/9/22 下午5:45
 */
@Component
@Slf4j
public class JwtAuthorizationTokenFilter extends OncePerRequestFilter {
    @Autowired
    private RedisService redisService;
    @Override
    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws ServletException, IOException {
        String token = request.getHeader(GlobalParam.TOKEN);
        if(token==null){
            Cookie cookie =  CookiesUtil.getCookieByName(request,GlobalParam.TOKEN);
            if(cookie!=null){
                token = cookie.getValue();
            }
        }
        Object o = redisService.get(token);
        if(o!=null){
            //如果token有值，转换为authentication 跳过牛逼哒默认session认证
            UserRedis userRedis = (UserRedis)o;
            if(StringUtils.isNotEmpty(userRedis.getUsername())&&SecurityContextHolder.getContext().getAuthentication() == null){
                UserDetails userDetails = new SecurityUserDetails(userRedis.getUsername(),new ArrayList<>());
                UsernamePasswordAuthenticationToken authentication = new UsernamePasswordAuthenticationToken(userDetails, null, userDetails.getAuthorities());
                SecurityContextHolder.getContext().setAuthentication(authentication);
            }
        }else {
        }
        filterChain.doFilter(request,response);
    }
}
