/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.config.resttemplate;

import com.biz.crm.config.resttemplate.HttpsClientRequestFactory;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.converter.StringHttpMessageConverter;
import org.springframework.stereotype.Component;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@Component
public class RestTemplateUtils {
    public static RestTemplate geTemplate() {
        RestTemplate restTemplate = new RestTemplate((ClientHttpRequestFactory)new HttpsClientRequestFactory());
        restTemplate.getMessageConverters().set(1, new StringHttpMessageConverter(StandardCharsets.UTF_8));
        return restTemplate;
    }

    public static <T> ResponseEntity<T> getForEntity(String url, Class<T> responseType, Map<String, ?> uriVariables) {
        return RestTemplateUtils.geTemplate().getForEntity(url, responseType, uriVariables);
    }

    public static <T> ResponseEntity<T> postForEntity(String url, HttpHeaders headers, Object requestBody, Class<T> responseType) {
        HttpEntity requestEntity = new HttpEntity(requestBody, (MultiValueMap)headers);
        return RestTemplateUtils.geTemplate().postForEntity(url, (Object)requestEntity, responseType, new Object[0]);
    }

    public static String postForObject(String url, HttpEntity httpEntity) {
        return (String)RestTemplateUtils.geTemplate().postForObject(url, (Object)httpEntity, String.class, new Object[0]);
    }

    public static <T> ResponseEntity<T> put(String url, HttpHeaders headers, Object requestBody, Class<T> responseType, Map<String, ?> uriVariables) {
        HttpEntity requestEntity = new HttpEntity(requestBody, (MultiValueMap)headers);
        return RestTemplateUtils.geTemplate().exchange(url, HttpMethod.PUT, requestEntity, responseType, uriVariables);
    }

    public static <T> ResponseEntity<T> delete(String url, HttpHeaders headers, Object requestBody, Class<T> responseType, Object ... uriVariables) {
        HttpEntity requestEntity = new HttpEntity(requestBody, (MultiValueMap)headers);
        return RestTemplateUtils.geTemplate().exchange(url, HttpMethod.DELETE, requestEntity, responseType, uriVariables);
    }

    public static <T> ResponseEntity<T> exchange(String url, HttpMethod method, HttpEntity<?> requestEntity, Class<T> responseType, Map<String, ?> uriVariables) {
        return RestTemplateUtils.geTemplate().exchange(url, method, requestEntity, responseType, uriVariables);
    }
}

