/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.util;

import com.biz.crm.util.StringUtils;
import javax.annotation.PostConstruct;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class DatabaseTypeUtil {
    public static String SEGMENT;
    public static String SEGMENT_ITEM;
    @Value(value="${crm.database.type:#{null}}")
    private String type;
    @Value(value="${spring.datasource.driverClassName:#{null}}")
    private String driverClassName;
    @Value(value="${crm.database.num:10000}")
    private String item;
    private static final String MYSQL = "mysql";
    private static final String ORACLE = "oracle";
    private static final String MYSQL_SEGMENT = " limit 1";
    private static final String MYSQL_SEGMENT_PREFIX = " limit ";
    private static final String ORACLE_SEGMENT = " rownum <= 1";
    private static final String ORACLE_SEGMENT_PREFIX = " rownum <=";

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @PostConstruct
    public void setUp() {
        if (!StringUtils.isEmpty((String)this.type)) {
            if (this.type.equalsIgnoreCase(MYSQL)) {
                SEGMENT = MYSQL_SEGMENT;
                this.setUpItem(MYSQL_SEGMENT_PREFIX);
                return;
            } else {
                if (!this.type.equalsIgnoreCase(ORACLE)) throw new RuntimeException("\u4e0d\u652f\u6301\u7684\u6570\u636e\u6e90\u7c7b\u578b");
                SEGMENT = ORACLE_SEGMENT;
                this.setUpItem(ORACLE_SEGMENT_PREFIX);
            }
            return;
        } else if (!StringUtils.isEmpty((String)this.driverClassName)) {
            if (this.driverClassName.contains(MYSQL)) {
                SEGMENT = MYSQL_SEGMENT;
                this.setUpItem(MYSQL_SEGMENT_PREFIX);
                return;
            } else {
                if (!this.driverClassName.contains(ORACLE)) throw new RuntimeException("\u4e0d\u652f\u6301\u7684\u6570\u636e\u6e90\u7c7b\u578b");
                SEGMENT = ORACLE_SEGMENT;
                this.setUpItem(ORACLE_SEGMENT_PREFIX);
            }
            return;
        } else {
            SEGMENT = MYSQL_SEGMENT;
            this.setUpItem(MYSQL_SEGMENT_PREFIX);
        }
    }

    private void setUpItem(String prefix) {
        SEGMENT_ITEM = prefix + this.item;
    }
}

