/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.util;

import com.biz.crm.base.BusinessException;
import com.biz.crm.base.config.ThreadLocalUtil;
import com.biz.crm.config.SpringApplicationContextUtil;
import com.biz.crm.mdm.MdmCommonUserFeign;
import com.biz.crm.nebular.mdm.user.resp.MdmUserRespVo;
import com.biz.crm.service.RedisService;
import com.biz.crm.util.CookiesUtil;
import com.biz.crm.util.HttpServletRequestUtil;
import com.biz.crm.util.Result;
import com.biz.crm.util.StringUtils;
import com.biz.crm.util.UserAutoConfig;
import com.biz.crm.util.UserRedis;
import io.jsonwebtoken.lang.Assert;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

public class UserUtils {
    private static final Logger log = LoggerFactory.getLogger(UserUtils.class);
    private static UserAutoConfig userAutoConfig = null;
    private static RedisService redisService;
    private static MdmCommonUserFeign mdmCommonUserFeign;
    private static String USER_GROUP_PREFIX;

    private static void initUserFeign() {
        if (mdmCommonUserFeign == null) {
            mdmCommonUserFeign = (MdmCommonUserFeign)SpringApplicationContextUtil.getApplicationContext().getBean(MdmCommonUserFeign.class);
        }
    }

    private static void initRedis() {
        if (redisService == null) {
            redisService = (RedisService)SpringApplicationContextUtil.getApplicationContext().getBean(RedisService.class);
        }
    }

    public static UserRedis getUser() {
        UserRedis user = ThreadLocalUtil.getUser();
        if (user != null && StringUtils.isNotEmpty((String)user.getUsername())) {
            return user;
        }
        UserRedis userRedis = null;
        try {
            String token = UserUtils.getToken();
            if (StringUtils.isEmpty((String)token)) {
                log.info("\u672a\u83b7\u53d6\u767b\u5f55\u7528\u6237token\u4fe1\u606f");
            } else {
                UserUtils.initRedis();
                Object o = redisService.get("token:" + token);
                if (o == null) {
                    redisService.setSeconds("token:" + token, null, 10L);
                } else {
                    userRedis = (UserRedis)o;
                    ThreadLocalUtil.setUser((UserRedis)userRedis);
                }
            }
        }
        catch (Exception e) {
            log.error("\u83b7\u53d6\u5f53\u524d\u7528\u6237:", (Throwable)e);
        }
        return userRedis;
    }

    public static String getToken() {
        Cookie cookie;
        String token;
        HttpServletRequest request = HttpServletRequestUtil.getRequest();
        Object tokenLock = ThreadLocalUtil.getObj((String)"loginUserToken");
        String string = token = tokenLock == null ? "" : tokenLock.toString();
        if (StringUtils.isNotEmpty((String)token) || request == null) {
            return token;
        }
        if (request != null && StringUtils.isEmpty((String)(token = request.getHeader("loginUserToken"))) && (cookie = CookiesUtil.getCookieByName(request, "loginUserToken")) != null) {
            token = cookie.getValue();
        }
        return token;
    }

    public static String getToken(String key) {
        UserUtils.initRedis();
        return redisService.getAndSet("token:" + key);
    }

    public static void setToken(String token) {
        ConcurrentHashMap<String, String> map = new ConcurrentHashMap<String, String>();
        map.put("loginUserToken", token);
        ThreadLocalUtil.stObj(map);
    }

    public static void doTokenForNull() {
        UserUtils.initConfig();
        if (StringUtils.isEmpty((String)userAutoConfig.getUsername())) {
            return;
        }
        try {
            ConcurrentHashMap<String, String> map = new ConcurrentHashMap<String, String>();
            String token = UUID.randomUUID().toString().replaceAll("-", "");
            map.put("loginUserToken", token);
            ThreadLocalUtil.stObj(map);
            UserUtils.setUser(token, userAutoConfig.getUsername());
        }
        catch (Exception e) {
            log.error("\u9ed8\u8ba4\u8bbe\u7f6e\u6743\u9650\u9519\u8bef", (Throwable)e);
        }
    }

    private static void initConfig() {
        if (userAutoConfig == null) {
            userAutoConfig = (UserAutoConfig)SpringApplicationContextUtil.getApplicationContext().getBean(UserAutoConfig.class);
        }
    }

    public static void setUser(String token, UserRedis userRedis) {
        Assert.hasText((String)token, (String)"token\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.notNull((Object)userRedis, (String)"userRedis\u4e0d\u80fd\u4e3a\u7a7a");
        UserUtils.initRedis();
        String username = userRedis.getUsername();
        Assert.hasText((String)username, (String)"\u7528\u6237\u5e10\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        List objects = (List)redisService.get(USER_GROUP_PREFIX + username);
        ArrayList<String> userTokenList = new ArrayList<String>();
        if (!CollectionUtils.isEmpty((Collection)objects)) {
            for (Object object : objects) {
                userTokenList.add((String)object);
            }
        }
        if (!userTokenList.contains(token)) {
            userTokenList.add(token);
        }
        redisService.setDays(USER_GROUP_PREFIX + username, userTokenList, 1L);
        for (String s : userTokenList) {
            UserUtils.setDaysUser(s, userRedis);
        }
    }

    public static void deleteUser(String username) {
        if (StringUtils.isEmpty((String)username)) {
            return;
        }
        List objects = (List)redisService.get(USER_GROUP_PREFIX + username);
        if (!CollectionUtils.isEmpty((Collection)objects)) {
            for (String token : objects) {
                UserUtils.deleteToken(token);
            }
        }
    }

    protected static void deleteToken(String token) {
        redisService.del(new String[]{"token:" + token});
    }

    public static void deleteUser(List<String> usernameList) {
        if (CollectionUtils.isEmpty(usernameList)) {
            return;
        }
        for (String username : usernameList) {
            UserUtils.deleteUser(username);
        }
    }

    public static void setUser(String token, String userName2) {
        UserUtils.initRedis();
        Assert.hasText((String)token, (String)"token\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.hasText((String)userName2, (String)"\u7528\u6237\u5e10\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        UserUtils.initUserFeign();
        UserRedis userRedis = new UserRedis();
        userRedis.setUsername(userName2);
        UserUtils.setDaysUser(token, userRedis);
        Result detail = mdmCommonUserFeign.detail(null, userName2);
        MdmUserRespVo mdmUserRespVo = Optional.ofNullable(detail).map(Result::getResult).orElseThrow(() -> new BusinessException("\u672a\u67e5\u8be2\u5230\u7528\u6237:" + userName2));
        userRedis.setRealname(mdmUserRespVo.getFullName());
        userRedis.setPoscode(mdmUserRespVo.getPositionCode());
        userRedis.setPosname(mdmUserRespVo.getPositionName());
        userRedis.setOrgname(mdmUserRespVo.getOrgName());
        userRedis.setOrgcode(mdmUserRespVo.getOrgCode());
        UserUtils.setDaysUser(token, userRedis);
    }

    protected static void setDaysUser(String token, UserRedis userRedis) {
        redisService.setDays("token:" + token, (Object)userRedis, 1L);
    }

    public static void remove() {
        String token;
        UserUtils.initRedis();
        String username = Optional.ofNullable(UserUtils.getUser()).map(UserRedis::getUsername).orElse(null);
        if (!StringUtils.isEmpty((String)username)) {
            UserUtils.deleteUser(username);
        }
        if (!StringUtils.isEmpty((String)(token = UserUtils.getToken()))) {
            UserUtils.deleteToken(token);
        }
    }

    public static List<String> handleOrgCodes(String orgCode) {
        if (StringUtils.isEmpty((String)orgCode)) {
            return null;
        }
        return Arrays.asList(orgCode.split(","));
    }

    static {
        USER_GROUP_PREFIX = "userGroup:";
    }
}

