/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.dict.feign;

import com.biz.crm.dict.entity.DictCategoryVo;
import com.biz.crm.dict.entity.DictVo;
import com.biz.crm.dict.entity.NebulaResult;
import com.biz.crm.nebular.mdm.dict.dictdata.req.MdmDictDataSearchReqVo;
import com.biz.crm.nebular.mdm.dict.dictdata.resp.MdmDictDataRespVo;
import com.biz.crm.util.Result;
import feign.hystrix.FallbackFactory;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.stereotype.Component;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

@FeignClient(url="${feign.urlip:}", qualifier="knlDictFeign", name="crm-mdm", fallbackFactory=FallBackClass.class)
public interface KnlDictFeign {
    @GetMapping(value={"/v1/nebula/dictCategories/findAll"})
    public NebulaResult<List<DictCategoryVo>> findAllDict();

    @GetMapping(value={"/v1/nebula/dictCategories/findByCode"})
    public NebulaResult<DictCategoryVo> findDictTypeByCode(@RequestParam(value="code") String var1);

    @GetMapping(value={"/v1/nebula/dicts/findDetailsByDictCode"})
    public NebulaResult<DictVo> findDictByDictCode(@RequestParam(value="dictCode") String var1);

    @PostMapping(value={"/mdm/dict_data/list"})
    public Result<List<MdmDictDataRespVo>> condition(@RequestBody MdmDictDataSearchReqVo var1);

    @Component
    public static class FallBackClass
    implements FallbackFactory<KnlDictFeign> {
        private static final Logger log = LoggerFactory.getLogger(FallBackClass.class);

        public KnlDictFeign create(Throwable throwable) {
            return new KnlDictFeign(){

                @Override
                public NebulaResult<List<DictCategoryVo>> findAllDict() {
                    log.error("\u67e5\u8be2\u6240\u6709\u5b57\u5178\u5206\u7c7b\u53ca\u6570\u636e\u5931\u8d25");
                    return NebulaResult.fail("\u67e5\u8be2\u6240\u6709\u5b57\u5178\u5206\u7c7b\u53ca\u6570\u636e\u5931\u8d25");
                }

                @Override
                public NebulaResult<DictCategoryVo> findDictTypeByCode(String typeCode) {
                    log.error("\u6839\u636e\u5206\u7c7b\u7f16\u7801\u67e5\u8be2\u5206\u7c7b\u5931\u8d25,\u5206\u7c7b\u7f16\u7801:{}", (Object)typeCode);
                    return NebulaResult.fail("\u6839\u636e\u5206\u7c7b\u7f16\u7801\u67e5\u8be2\u5206\u7c7b\u5931\u8d25");
                }

                @Override
                public NebulaResult<DictVo> findDictByDictCode(String dictCode) {
                    log.error("\u6839\u636e\u5b57\u5178\u7f16\u7801\u67e5\u8be2\u6307\u5b9a\u5b57\u5178\u5931\u8d25");
                    return NebulaResult.fail("\u6839\u636e\u5b57\u5178\u7f16\u7801\u67e5\u8be2\u6307\u5b9a\u5b57\u5178\u5931\u8d25");
                }

                @Override
                public Result<List<MdmDictDataRespVo>> condition(MdmDictDataSearchReqVo mdmDictDataSearchReqVo) {
                    log.error("\u6839\u636e\u6761\u4ef6\u67e5\u8be2\u5b57\u5178\u5931\u8d25");
                    return Result.ok(Collections.emptyList());
                }
            };
        }
    }
}

