/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.util;

import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.BeanUtils;

public class CrmBeanUtil {
    public static void copyProperties(Object source, Object target) {
        BeanUtils.copyProperties((Object)source, (Object)target);
    }

    public static <T> T copy(Object source, Class<T> target) {
        try {
            T newInstance = target.newInstance();
            BeanUtils.copyProperties((Object)source, newInstance);
            return newInstance;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static <T, K> List<K> copyList(List<T> source, Class<K> target) {
        if (null == source || source.isEmpty()) {
            return Collections.emptyList();
        }
        return source.stream().map(e -> CrmBeanUtil.copy(e, target)).collect(Collectors.toList());
    }
}

