/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.util;

import com.biz.crm.config.SpringApplicationContextUtil;
import com.biz.crm.service.RedisService;
import com.biz.crm.util.HttpServletRequestUtil;
import com.biz.crm.util.StringUtils;
import com.biz.crm.util.UserRedis;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UserUtils {
    private static final Logger log = LoggerFactory.getLogger(UserUtils.class);
    private static RedisService redisService;

    private static void initRedis() {
        if (redisService == null) {
            redisService = (RedisService)SpringApplicationContextUtil.getApplicationContext().getBean(RedisService.class);
        }
    }

    public static UserRedis getUser() {
        UserRedis userRedis = null;
        try {
            String token = UserUtils.getToken();
            if (StringUtils.isEmpty((String)token)) {
                return null;
            }
            UserUtils.initRedis();
            Object o = redisService.get(token);
            if (o == null) {
                redisService.setSeconds(token, null, 10L);
            } else {
                userRedis = (UserRedis)o;
            }
        }
        catch (Exception e) {
            log.error("\u83b7\u53d6\u5f53\u524d\u7528\u6237:", (Throwable)e);
        }
        return userRedis;
    }

    public static String getToken() {
        HttpServletRequest request = HttpServletRequestUtil.getRequest();
        if (request == null) {
            return null;
        }
        String token = request.getHeader("loginUserToken");
        return token;
    }
}

