/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.aop;

import com.biz.crm.util.UserRedis;
import com.biz.crm.util.UserUtils;
import java.lang.reflect.Method;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Aspect
@Component
public class WebLogAspect {
    private static final Logger log = LoggerFactory.getLogger(WebLogAspect.class);

    @Pointcut(value="execution(public * com.biz.crm.*..*(..))")
    public void webLogPointcut() {
    }

    @Before(value="@annotation(CrmLog)")
    public void doBefore(JoinPoint joinPoint) {
        Class<?> clazz = joinPoint.getTarget().getClass();
        Method method = ((MethodSignature)joinPoint.getSignature()).getMethod();
        Object[] args = joinPoint.getArgs();
        if (args == null || args.length == 0) {
            return;
        }
        log.info("------------------------------------------AOP\u65e5\u5fd7start--------------------------------------------------------");
        log.info("[AOP\u65e5\u5fd7]:\u7c7b\u540d:{}", (Object)clazz.getName());
        log.info("[AOP\u65e5\u5fd7]:\u65b9\u6cd5\u540d:{}", (Object)method.getName());
        for (Object arg : args) {
            if (arg instanceof HttpServletRequest || arg instanceof HttpServletResponse) continue;
            log.info("[AOP\u65e5\u5fd7]:\u65b9\u6cd5\u5165\u53c2:{}", args);
        }
        UserRedis user = UserUtils.getUser();
        log.info("[AOP\u65e5\u5fd7]:\u8bf7\u6c42\u7528\u6237:{}", (Object)user);
        log.info("------------------------------------------AOP\u65e5\u5fd7end--------------------------------------------------------");
    }
}

