/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.util;

import com.alibaba.excel.util.CollectionUtils;
import com.biz.crm.config.SpringApplicationContextUtil;
import com.biz.crm.dict.entity.DictVo;
import com.biz.crm.dict.feign.KnlDictFeign;
import com.biz.crm.nebular.mdm.dict.dictdata.req.MdmDictDataSearchReqVo;
import com.biz.crm.nebular.mdm.dict.dictdata.resp.MdmDictDataRespVo;
import com.biz.crm.service.RedisService;
import com.biz.crm.util.Result;
import com.biz.crm.util.StringUtils;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DictUtil {
    private static final Logger log = LoggerFactory.getLogger(DictUtil.class);
    private static final String DICT_REDIS = "dictRedis";
    private static final String DICT_FEIGN = "dictFeign";
    private static volatile RedisService redisService;
    private static volatile KnlDictFeign knlDictFeign;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void getRedisService() {
        if (redisService != null) return;
        String string = DICT_REDIS;
        synchronized (DICT_REDIS) {
            if (redisService != null) return;
            redisService = (RedisService)SpringApplicationContextUtil.getApplicationContext().getBean("redisService");
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void getKnlDictFeign() {
        if (knlDictFeign != null) return;
        String string = DICT_FEIGN;
        synchronized (DICT_FEIGN) {
            if (knlDictFeign != null) return;
            knlDictFeign = (KnlDictFeign)SpringApplicationContextUtil.getApplicationContext().getBean("knlDictFeign");
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    public static Map<String, Map<String, String>> getDictValueMapsByCodes(List<String> dictCodes) {
        return new HashMap<String, Map<String, String>>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<Object, Object> getDictMap(String dictTypeCode) {
        if (StringUtils.isEmpty((String)dictTypeCode)) {
            log.error("\u5b57\u5178\u5206\u7c7b\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
            return Collections.emptyMap();
        }
        DictUtil.getRedisService();
        Map map = redisService.hmget("DICT_DATA_:" + dictTypeCode);
        if (CollectionUtils.isEmpty((Map)map)) {
            DictUtil.getKnlDictFeign();
            String string = "DICT_DATA_:" + dictTypeCode;
            synchronized (string) {
                if (CollectionUtils.isEmpty((Map)map)) {
                    Result<List<MdmDictDataRespVo>> condition = knlDictFeign.condition(new MdmDictDataSearchReqVo().setDictTypeCode(dictTypeCode));
                    log.info("[method:getDictMap]\u6839\u636e\u5b57\u5178\u7f16\u7801\u8fd4\u56de\u6240\u6709\u5b57\u5178\u503c,result:{}", condition);
                    return Optional.ofNullable(condition).map(Result::getResult).map(x -> {
                        Map collect = x.stream().collect(Collectors.toMap(MdmDictDataRespVo::getDictCode, Function.identity()));
                        redisService.hmset("DICT_DATA_:" + dictTypeCode, collect, 2592000L);
                        return collect;
                    }).orElseGet(() -> {
                        redisService.hmset("DICT_DATA_:" + dictTypeCode, map, 10L);
                        return map;
                    });
                }
            }
        }
        return map;
    }

    public static MdmDictDataRespVo getDicData(String dictTypeCode, String dictCode) {
        return (MdmDictDataRespVo)Optional.of(redisService.hget("DICT_DATA_:" + dictTypeCode, dictCode)).orElseGet(() -> Optional.of(DictUtil.getDictMap(dictCode)).map(x -> (DictVo)x.get(dictCode)).orElse(null));
    }

    public static String getDictDataVal(String dictTypeCode, String dictCode) {
        return Optional.of(DictUtil.getDicData(dictTypeCode, dictCode)).map(MdmDictDataRespVo::getDictValue).orElse(null);
    }

    public static List<MdmDictDataRespVo> getDictList(String dictTypeCode) {
        return Optional.of(DictUtil.getDictMap(dictTypeCode)).map(x -> Arrays.asList((MdmDictDataRespVo[])x.values().toArray())).orElse(Collections.emptyList());
    }
}

