package com.biz.crm.eunm.mdm;

/**
 * @Description:数据权限的权限对象枚举
 * @Author: zhangyuzhu
 * @Date: 2020/8/20 18:25
 **/
public enum MdmPermissionObjEnum {
    /**
     * 数据权限的权限对象枚举
     */
    ORG("org","组织"),
    POSITION("position","职位"),
    CHANNEL("channel","渠道"),
    CUSTOMER_ORG("customer_org", "客户组织"),
    TERMINAL("terminal", "终端"),
    CUSTOMER("customer", "客户"),
    DEFAULT("default", "默认"),;

    private String code;
    private String des;

    MdmPermissionObjEnum(String code, String des) {
        this.code = code;
        this.des = des;
    }

    public String getCode() {
        return code;
    }

    public String getDes() {
        return des;
    }

    public static boolean contain(String code) {
        if(code==null||"".equals(code.trim())){
            return false;
        }
        MdmPermissionObjEnum[] values = MdmPermissionObjEnum.values();
        for (MdmPermissionObjEnum value : values) {
            if (value.getCode().equals(code)) {
                return true;
            }
        }
        return false;
    }

    public static MdmPermissionObjEnum convertEnum(String code) {
        if(code==null||"".equals(code.trim())){
            return DEFAULT;
        }
        MdmPermissionObjEnum[] values = MdmPermissionObjEnum.values();
        for (MdmPermissionObjEnum value : values) {
            if (value.getCode().equals(code)) {
                return value;
            }
        }
        return DEFAULT;
    }

    public static String getSubDictTypeCode(String code) {
        if (code == null || "".equals(code.trim())) {
            return null;
        }
        MdmPermissionObjEnum[] values = MdmPermissionObjEnum.values();
        for (MdmPermissionObjEnum value : values) {
            if (value.getCode().equals(code)) {
                return "permission_obj_" + code;
            }
        }
        return null;
    }
}
