package com.biz.crm.util.fee;

import com.biz.crm.eunm.YesNoEnum;
import com.biz.crm.nebular.fee.pool.resp.FeeSelectOptionVo;
import com.biz.crm.nebular.mdm.constant.DictConstant;
import com.biz.crm.util.DictUtil;
import org.springframework.util.Assert;

import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class FeePoolConfigUtil {

    public static List<FeeSelectOptionVo> getDiscountSelectList() {
        return DictUtil.list(DictConstant.FEE_POOL_DISCOUNT_TYPE).stream().map(item -> {
            FeeSelectOptionVo option = new FeeSelectOptionVo();
            option.setValue(item.getDictCode());
            option.setText(item.getDictValue());
            return option;
        }).collect(Collectors.toList());
    }

    public static List<FeeSelectOptionVo> getAllOperationTypeSelectList() {
        return DictUtil.list(DictConstant.FEE_POOL_OPERATION_TYPE).stream().map(item -> {
            FeeSelectOptionVo option = new FeeSelectOptionVo();
            option.setValue(item.getDictCode());
            option.setText(item.getDictValue());
            return option;
        }).collect(Collectors.toList());
    }

    public static List<FeeSelectOptionVo> getShowInDetailOperationTypeSelectList() {
        return DictUtil.list(DictConstant.FEE_POOL_OPERATION_TYPE).stream().filter(item -> YesNoEnum.yesNoEnum.ONE.getValue().equals(item.getExtendMap().get("showInDetail"))).map(item -> {
            FeeSelectOptionVo option = new FeeSelectOptionVo();
            option.setValue(item.getDictCode());
            option.setText(item.getDictValue());
            return option;
        }).collect(Collectors.toList());
    }

    public static List<FeeSelectOptionVo> getUseInAccountOperationTypeSelectList() {
        return DictUtil.list(DictConstant.FEE_POOL_OPERATION_TYPE).stream().filter(item -> YesNoEnum.yesNoEnum.ONE.getValue().equals(item.getExtendMap().get("useInAccount"))).map(item -> {
            FeeSelectOptionVo option = new FeeSelectOptionVo();
            option.setValue(item.getDictCode());
            option.setText(item.getDictValue());
            return option;
        }).collect(Collectors.toList());
    }

    public static String getPayType(String poolType) {
        String poolTypeValue = DictUtil.dictValue(DictConstant.FEE_POOL_TYPE, poolType);
        Assert.hasText(poolTypeValue, "无效的费用池类型");
        Map<String, String> discountExtendMap = DictUtil.getExtendMap(DictConstant.FEE_POOL_TYPE, poolType);
        String payType = discountExtendMap.get(DictConstant.FEE_POOL_TYPE_PAY_TYPE_EXTEND_FIELD);
        Assert.hasText(payType, poolTypeValue + "未配置支付方式");
        return payType;
    }

    public static boolean checkOperationTypeUseInAccount(String operationType) {
        String operationTypeValue = DictUtil.dictValue(DictConstant.FEE_POOL_OPERATION_TYPE, operationType);
        Assert.hasText(operationTypeValue, "无效的操作类型");
        Map<String, String> extendMap = DictUtil.getExtendMap(DictConstant.FEE_POOL_OPERATION_TYPE, operationType);
        String useInAccount = extendMap.get("useInAccount");
        Assert.hasText(useInAccount, "操作类型" + operationTypeValue + "未配置是否在上账中使用");
        return YesNoEnum.yesNoEnum.ONE.getValue().equals(useInAccount);
    }

    public static boolean checkOperationTypeCanUseInDetail(String operationType) {
        String operationTypeValue = DictUtil.dictValue(DictConstant.FEE_POOL_OPERATION_TYPE, operationType);
        Assert.hasText(operationTypeValue, "无效的操作类型");
        Map<String, String> extendMap = DictUtil.getExtendMap(DictConstant.FEE_POOL_OPERATION_TYPE, operationType);
        String useInDetail = extendMap.get("useInDetail");
        Assert.hasText(useInDetail, "操作类型" + operationTypeValue + "未配置金额是否可使用");
        return YesNoEnum.yesNoEnum.ONE.getValue().equals(useInDetail);
    }

    public static BigDecimal getOperationTypeWeight(String operationType) {
        String operationTypeValue = DictUtil.dictValue(DictConstant.FEE_POOL_OPERATION_TYPE, operationType);
        Assert.hasText(operationTypeValue, "无效的操作类型");
        Map<String, String> extendMap = DictUtil.getExtendMap(DictConstant.FEE_POOL_OPERATION_TYPE, operationType);
        String weight = extendMap.get("weight");
        Assert.hasText(weight, "操作类型" + operationTypeValue + "未配置权重");
        return new BigDecimal(weight);
    }

}
