package com.biz.crm.aop;

import com.biz.crm.base.BusinessException;
import lombok.extern.slf4j.Slf4j;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;
import org.aspectj.lang.reflect.MethodSignature;
import org.springframework.stereotype.Component;

import java.lang.reflect.Method;


/**
 * 废弃方法切面，抛出异常
 *  @author: luoqi
 *  @Date: 2020-12-2 11:20
 *  @version: V1.0
 *  @Description:
 */
@Aspect
@Component
@Slf4j
public class APIDiscardAspect {


    public APIDiscardAspect() {
    }


    /**
     * 废弃方法切面，抛出异常
     * @param joinPoint
     */
    @Before("@annotation(CrmAPIDiscard)")
    public void doBefore(JoinPoint joinPoint) {
        Class<?> clazz = joinPoint.getTarget().getClass();
        Method method = ((MethodSignature) joinPoint.getSignature()).getMethod();
        CrmAPIDiscard crmAPIDiscard = method.getAnnotation(CrmAPIDiscard.class);
        String msg = crmAPIDiscard.msg().replace(CrmAPIDiscard.API_NAME, clazz.getSimpleName() + "." + method.getName());
        throw new BusinessException(msg);
    }

//    /**
//     * 返回通知：
//     * 1. 在目标方法正常结束之后执行
//     * 1. 在返回通知中补充请求日志信息，如返回时间，方法耗时，返回值，并且保存日志信息
//     *
//     * @param ret
//     * @throws Throwable
//     */
//    @AfterReturning(returning = "ret", pointcut = "webLogPointcut()")
//    public void doAfterReturning(Object ret) throws Throwable {
//    }

//    /**
//     * 异常通知：
//     * 1. 在目标方法非正常结束，发生异常或者抛出异常时执行
//     * 1. 在异常通知中设置异常信息，并将其保存
//     *
//     * @param throwable
//     */
//    @AfterThrowing(value = "webLogPointcut()", throwing = "throwable")
//    public void doAfterThrowing(Throwable throwable) {
//        // 保存异常日志记录
//        log.error("发生异常时间：{}" + LocalDateTime.now());
//        log.error("抛出异常：{}" + throwable.getMessage());
//    }
}
