package com.biz.crm.eunm.tpm;

import org.apache.commons.lang3.StringUtils;

/**
 * @Description:crm 活动细类发布需求枚举
 * @Author: huanglong
 * @Date: 2020/8/20 18:25
 **/
public enum ActivityReleaseNeedEnum {
    DEPARTMENT("department","部门"),
    CUSTOMER("customer","客户"),
    TERMINAL("terminal","终端"),
    ;

    private String code;
    private String des;

    ActivityReleaseNeedEnum(String code, String des) {
        this.code = code;
        this.des = des;
    }

    public String getCode() {
        return code;
    }

    public String getDes() {
        return des;
    }

    public static String getStatusName(String code){
        ActivityReleaseNeedEnum[] values = ActivityReleaseNeedEnum.values();
        String desc=null;
        for (ActivityReleaseNeedEnum o : values){
            if(StringUtils.equals(o.getCode(),code)){
                desc=o.getDes();
                break;
            }
        }
        return desc;
    }
}
