package com.biz.crm.util.fee;

import com.biz.crm.eunm.YesNoEnum;
import com.biz.crm.eunm.fee.FeePoolOperationTypeExtendEnum;
import com.biz.crm.eunm.fee.FeePoolOperationTypeGroupEnum;
import com.biz.crm.nebular.fee.pool.resp.FeeSelectOptionVo;
import com.biz.crm.nebular.mdm.constant.DictConstant;
import com.biz.crm.util.DictUtil;
import org.springframework.util.Assert;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class FeePoolConfigUtil {

    /**
     * 获取折扣类型下拉框
     *
     * @return
     */
    public static List<FeeSelectOptionVo> getDiscountSelectList() {
        return DictUtil.list(DictConstant.FEE_POOL_DISCOUNT_TYPE).stream().map(item -> {
            FeeSelectOptionVo option = new FeeSelectOptionVo();
            option.setValue(item.getDictCode());
            option.setText(item.getDictValue());
            return option;
        }).collect(Collectors.toList());
    }

    /**
     * 获取全部操作类型下拉框
     *
     * @return
     */
    public static List<FeeSelectOptionVo> getAllOperationTypeSelectList() {
        return DictUtil.list(DictConstant.FEE_POOL_OPERATION_TYPE).stream().map(item -> {
            FeeSelectOptionVo option = new FeeSelectOptionVo();
            option.setValue(item.getDictCode());
            option.setText(item.getDictValue());
            return option;
        }).collect(Collectors.toList());
    }

    public static List<FeeSelectOptionVo> getOperationTypeSelectList(String filterExtend) {
        return DictUtil.list(DictConstant.FEE_POOL_OPERATION_TYPE)
                .stream()
                .filter(item -> YesNoEnum.yesNoEnum.ONE.getValue().equals(item.getExtendMap().get(filterExtend)))
                .map(item -> {
                    FeeSelectOptionVo option = new FeeSelectOptionVo();
                    option.setValue(item.getDictCode());
                    option.setText(item.getDictValue());
                    return option;
                }).collect(Collectors.toList());
    }

    public static boolean checkOperationTypeUsable(String operationType, FeePoolOperationTypeExtendEnum feePoolOperationTypeExtendEnum) {
        String operationTypeValue = DictUtil.dictValue(DictConstant.FEE_POOL_OPERATION_TYPE, operationType);
        Assert.hasText(operationTypeValue, "无效的操作类型");
        Map<String, String> extendMap = DictUtil.getExtendMap(DictConstant.FEE_POOL_OPERATION_TYPE, operationType);
        Assert.isTrue(extendMap.containsKey(feePoolOperationTypeExtendEnum.getValue()), "操作类型" + operationTypeValue + "未配置" + feePoolOperationTypeExtendEnum.getDesc());
        return YesNoEnum.yesNoEnum.ONE.getValue().equals(extendMap.get(feePoolOperationTypeExtendEnum.getValue()));
    }

    public static String getPayType(String poolType) {
        String poolTypeValue = DictUtil.dictValue(DictConstant.FEE_POOL_TYPE, poolType);
        Assert.hasText(poolTypeValue, "无效的费用池类型");
        Map<String, String> discountExtendMap = DictUtil.getExtendMap(DictConstant.FEE_POOL_TYPE, poolType);
        String payType = discountExtendMap.get(DictConstant.FEE_POOL_TYPE_PAY_TYPE_EXTEND_FIELD);
        Assert.hasText(payType, poolTypeValue + "未配置支付方式");
        return payType;
    }

    public static FeePoolOperationTypeGroupEnum getOperationTypeGroup(String operationType) {
        String operationTypeValue = DictUtil.dictValue(DictConstant.FEE_POOL_OPERATION_TYPE, operationType);
        Assert.hasText(operationTypeValue, "无效的操作类型");
        Map<String, String> extendMap = DictUtil.getExtendMap(DictConstant.FEE_POOL_OPERATION_TYPE, operationType);
        String group = extendMap.get(FeePoolOperationTypeExtendEnum.GROUP.getValue());
        Assert.hasText(group, "操作类型" + operationTypeValue + "未配置" + FeePoolOperationTypeExtendEnum.GROUP.getDesc());
        FeePoolOperationTypeGroupEnum anEnum = FeePoolOperationTypeGroupEnum.getEnum(group);
        Assert.notNull(anEnum, "操作类型" + operationTypeValue + "配置分组无效");
        return anEnum;
    }

}
