package com.biz.crm.util;

import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

import javax.annotation.PostConstruct;

/**
 * 数据源类型
 *
 * @author zxw
 * @date 2020-09-27 14:40
 **/
@Component
public class DatabaseTypeUtil {

    public static String SEGMENT;

    public static String SEGMENT_ITEM;

    @Value("${crm.database.type:#{null}}")
    private String type;

    @Value("${spring.datasource.driverClassName:#{null}}")
    private String driverClassName;

    @Value("${crm.database.num:10000}")
    private String item;

    private static final String MYSQL = "mysql";

    private static final String ORACLE = "oracle";

    private static final String MYSQL_SEGMENT = " limit 1";

    private static final String MYSQL_SEGMENT_PREFIX = " limit ";

    private static final String ORACLE_SEGMENT = " and rownum <= 1";

    private static final String ORACLE_SEGMENT_PREFIX = " and rownum <=";

    @PostConstruct
    public void setUp() {
        if (!StringUtils.isEmpty(type)) {
            if (type.equalsIgnoreCase(MYSQL)) {
                SEGMENT = MYSQL_SEGMENT;
                setUpItem(MYSQL_SEGMENT_PREFIX);
            } else if (type.equalsIgnoreCase(ORACLE)) {
                SEGMENT = ORACLE_SEGMENT;
                setUpItem(ORACLE_SEGMENT_PREFIX);
            } else {
                throw new RuntimeException("不支持的数据源类型");
            }
        } else if (!StringUtils.isEmpty(driverClassName)) {
            if (driverClassName.contains(MYSQL)) {
                SEGMENT = MYSQL_SEGMENT;
                setUpItem(MYSQL_SEGMENT_PREFIX);
            } else if (driverClassName.contains(ORACLE)) {
                SEGMENT = ORACLE_SEGMENT;
                setUpItem(ORACLE_SEGMENT_PREFIX);
            } else {
                throw new RuntimeException("不支持的数据源类型");
            }
        } else {
            SEGMENT = MYSQL_SEGMENT;
            setUpItem(MYSQL_SEGMENT_PREFIX);
        }
    }

    private void setUpItem(String prefix) {
        SEGMENT_ITEM = prefix + item;
    }

}
