package com.biz.crm.exception.tpm;

import com.biz.crm.exception.CrmExceptionType;

/**
 * @Project crm
 * @PackageName com.biz.crm.exception.tpm
 * @ClassName CostTypeCategoriesException
 * @Author HuangLong
 * @Date 2020/9/2 11:04
 * @Description 活动大类异常枚举
 */
public enum CostTypeCategoriesException implements CrmExceptionType {

    DATA_NOT_EXIST("tpm_40001","活动大类数据不存在"),
    DATA_DUPLICATE("tpm_40002","活动大类数据重复,请检查"),
    DATA_CODE_DUPLICATE("tpm_40002","活动大类编码已存在,请检查"),

    ;

    private String code;
    private String description;

    CostTypeCategoriesException(String code, String description) {
        this.code = code;
        this.description = description;
    }

    @Override
    public String getCode() {
        return code;
    }

    @Override
    public String getDescription() {
        return description;
    }
}
