package com.biz.crm.util;

import com.biz.crm.base.BusinessException;
import com.google.common.collect.Lists;

import java.util.List;


/**
 * Result 工具类
 *  @author: luoqi
 *  @Date: 2020-12-16 11:27
 *  @version: V1.0
 *  @Description:
 */
public class ResultUtil {
    private ResultUtil(){}

    /**
     * 把json 解析 成指定对象
     * @param json
     * @param clazz
     * @param notNull
     * @param <T>
     * @return
     */
    public static <T> List<T> listResultFromJsonStr(String json, Class<T> clazz, boolean notNull){
        Result<List<T>> resultObj = JsonPropertyUtil.toObject(json, Result.class);
        if(null == resultObj){
            throw new BusinessException("响应体错误");
        }
        if( null == resultObj.getResult()){
            if(notNull){
                throw new BusinessException(resultObj.getMessage());
            }else {
                return Lists.newArrayList();
            }
        }

        return JsonPropertyUtil.toArray(JsonPropertyUtil.toJsonString(resultObj.getResult()), clazz);
    }

}
