package com.biz.crm.config;

import com.biz.crm.base.config.ThreadLocalUtil;
import com.biz.crm.common.GlobalParam;
import feign.RequestInterceptor;
import feign.RequestTemplate;
import lombok.extern.slf4j.Slf4j;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@Slf4j
public class FeignHeaderInterceptor implements RequestInterceptor {
    @Override
    public void apply(RequestTemplate requestTemplate) {
        try {
            Object tokenLock = ThreadLocalUtil.getObj(GlobalParam.TOKEN);
            Object menuCodeAsObj = ThreadLocalUtil.getObj(GlobalParam.MENU_CODE);
            Object functionCodeAsObj = ThreadLocalUtil.getObj(GlobalParam.FUNCTION_CODE);
            String loginUserToken = tokenLock==null?"":tokenLock.toString();
            String menuCode = menuCodeAsObj == null ? "" : menuCodeAsObj.toString();
            String functionCode = functionCodeAsObj == null ? "" : functionCodeAsObj.toString();
            requestTemplate.header(GlobalParam.TOKEN, loginUserToken);
            requestTemplate.header(GlobalParam.MENU_CODE, menuCode);
            requestTemplate.header(GlobalParam.FUNCTION_CODE, functionCode);
        } catch (Exception e) {
            log.error("feign错误:",e);
            //当无登录状态时不需要传信息
            requestTemplate.header(GlobalParam.TOKEN, "");
        }
    }
    @Bean
    public FeignHystrixConcurrencyStrategy feignHystrixConcurrencyStrategy() {
        return new FeignHystrixConcurrencyStrategy();
    }
}
