package com.biz.crm.config;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.biz.crm.base.BusinessException;
import com.biz.crm.base.config.ThreadLocalUtil;
import com.biz.crm.common.param.RedisParam;
import com.biz.crm.handler.KlockTimeoutException;
import com.biz.crm.service.RedisService;
import com.biz.crm.util.*;
import com.biz.crm.wx.WxMsgUtil;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.WebDataBinder;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.InitBinder;
import org.springframework.web.bind.annotation.ResponseBody;

import javax.annotation.PostConstruct;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;

/**
 * @author jianglong
 * @version V1.0
 * @Package com.biz.crm.config
 * @Description: TODO
 * @date 2020/9/1 下午5:32
 */
@ControllerAdvice
@Slf4j
public class GlobalExceptionHandler {
    @Value("${spring.application.name:}")
    private String applicationName;
    private static RedisService redisService;
    private static  String send_wx_msg = null;

    private static String APPLICATION_NAME;

    @Value("${spring.profiles.active:}")
    private String profilesActive;

    private static String PROFILES_ACTIVE;

    @PostConstruct
    public void init() {
        APPLICATION_NAME = this.applicationName;
        PROFILES_ACTIVE=this.profilesActive;
    }

    /**
     * 应用到所有@RequestMapping注解方法，在其执行之前初始化数据绑定器
     *
     * @param binder
     */
    @InitBinder
    public void initBinder(WebDataBinder binder) {

    }

    /**
     * 全局异常捕捉处理
     *
     * @return
     */
    @ExceptionHandler(value = Exception.class)
    @ResponseBody
    public Result errorHandler(Exception e, HttpServletRequest request, HttpServletResponse response) {
        UserRedis userRedis = UserUtils.getUser();
        if(userRedis!=null){
            log.error("进入全局异常当前登录人信息 ： "+JSON.toJSONString(userRedis));
        }
        log.error("进入全局异常", e);
        ExceptionMsg exceptionMsg =  getExceptionToString(e,request.getRequestURL());
        return Result.error("操作失败,错误编码"+exceptionMsg.getCode());
    }


    /**
     * 全局异常捕捉处理
     *
     * @return
     */
    @ExceptionHandler(value = {BusinessException.class})
    @ResponseBody
    public Result errorHandler(BusinessException e, HttpServletRequest request, HttpServletResponse response) {
        UserRedis userRedis = UserUtils.getUser();
        if(userRedis!=null){
            log.error("进入全局异常当前登录人信息 ： "+JSON.toJSONString(userRedis));
        }
        log.error("进入全局业务异常处理", e);
        return Result.error(e.getMsg());
    }

    /**
     * 全局异常捕捉处理
     *
     * @return
     */
    @ExceptionHandler(value = {IOException.class})
    @ResponseBody
    public Result ioeHandler(IOException e, HttpServletRequest request, HttpServletResponse response) {
        UserRedis userRedis = UserUtils.getUser();
        if(userRedis!=null){
            log.error("进入全局异常当前登录人信息 ： "+JSON.toJSONString(userRedis));
        }
        log.error("进入全局业务异常处理", e);
        return null;
    }


    @ExceptionHandler(value = {IllegalArgumentException.class})
    @ResponseBody
    public Result assertHandler(IllegalArgumentException e, HttpServletRequest request, HttpServletResponse response) {
        String message = e.getMessage();
        UserRedis userRedis = UserUtils.getUser();
        if(userRedis!=null){
            log.error("进入全局异常当前登录人信息 ： "+JSON.toJSONString(userRedis));
        }
        log.error("进入全局业务异常处理", e);
        return Result.error(message);
    }

    private static ExceptionMsg getExceptionToString(Throwable e,StringBuffer url) {
        url = url==null?new StringBuffer():url;
        ExceptionMsg vo = new ExceptionMsg();
        if(redisService==null){
            redisService = SpringApplicationContextUtil.getApplicationContext().getBean(RedisService.class);
        }
        long numCode= redisService.incr(RedisParam.ERROE_CODE,1);
        if (numCode==999999){
            redisService.set(RedisParam.ERROE_CODE,1);
            numCode=1;
        }
        String errorCode = "E"+String.valueOf(numCode);
        vo.setCode(errorCode);
        if (e == null){
            return vo;
        }
        UserRedis userRedis = UserUtils.getUser();
        StringBuffer userMsg = new StringBuffer();
        userMsg.append("\t当前报错系统==>").append(APPLICATION_NAME);
        userMsg.append("\n\t当前token==>").append(UserUtils.getToken());
        userMsg.append("\n\t当前登录人信息==>");
        if(userRedis!=null){
            userMsg.append(JSONObject.toJSONString(userRedis));
        }else {
            userMsg.append("无登录信息");
        }
        userMsg.append("\n\t");
        String msg = userMsg.toString()+"请求url:"+url+ "\n\t错误时间（"+DateUtil.dateNowHms()+"） \n\t";
        String parameter = ThreadLocalUtil.getParameter()+ "\n\t";
        msg += parameter;
        StringWriter stringWriter = new StringWriter();
        e.printStackTrace(new PrintWriter(stringWriter));
        msg += stringWriter.toString();
        vo.setMsg(msg);
        redisService.setDays(RedisParam.ERROE_MSG+errorCode,vo, RedisParam.TIME3);
        if(send_wx_msg==null){
            String v =  ParamUtil.getParameterValue("send_wx_msg");
            send_wx_msg = v==null?"N":v;
        }else if("Y".equals(send_wx_msg)){
            createMsgAndSend(errorCode,vo,url.toString());
        }
        return vo;
    }

    /**
     * 创建移除消息
     * @param errorCode
     * @param vo
     */
    private static void createMsgAndSend(String errorCode,ExceptionMsg vo,String  url){
        try {
            if(StringUtils.isNotEmpty(url)&&url.contains("localhost")){
                return;
            }
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("<font color=\"red\">"+APPLICATION_NAME+"  ("+PROFILES_ACTIVE+"环境!!)  "+"错误编码["+errorCode+"](http://www.baidu.com/)异常消息反馈，请相关同事注意！！</font> \n");
            stringBuffer.append(">请求地址:<font color=\"comment\">"+url+"</font>");
            WxMsgUtil.sendMarkdownMsg(stringBuffer.toString());
        }catch (Exception e){
            log.error("消息微信推送失败",e);
        }
    }

    /**
     * 全局异常捕捉处理
     *
     * @return
     */
    @ExceptionHandler(value = {KlockTimeoutException.class})
    @ResponseBody
    public Result kLockHandler(KlockTimeoutException e, HttpServletRequest request, HttpServletResponse response) {
        UserRedis userRedis = UserUtils.getUser();
        String message = e.getMessage();
        if(userRedis!=null){
            log.error("进入全局异常当前登录人信息 ： "+JSON.toJSONString(userRedis));
        }
        log.error("进入全局业务异常处理", e);
        return Result.error("请不要重复提交");
    }

}
