package com.biz.crm.util;

import com.biz.crm.eunm.CrmContant;
import org.redisson.api.RLock;
import org.springframework.data.elasticsearch.core.ElasticsearchTemplate;

import java.util.concurrent.ConcurrentHashMap;

/**
 * @Author zhangyuzhu
 * @Description
 * @Created data 2019/7/10 10:33
 */
public class EsUtil {

	/**
	 * 用于保存索引是否存在的HashMap
	 */
	private static final ConcurrentHashMap<String,Object> indexMap = new ConcurrentHashMap();

	private static final Object obj = new Object();




	/**
	 * 判断索引是否存在，如果不存在就创建
	 * @param elasticsearchTemplate
	 * @param clazz
	 * @return
	 */
	public static boolean indexExsit(ElasticsearchTemplate elasticsearchTemplate, Class clazz, RedissonUtil redissonUtil){
		if(indexMap.containsKey(clazz.getName())){
			return true;
		}
		if(elasticsearchTemplate.indexExists(clazz)){
			indexMap.put(clazz.getName(),obj);
			return true;
		}
		RLock rLock = redissonUtil.createLock(new StringBuffer(CrmContant.INDEX_CREATE_PRE).append(clazz.getName()).toString());
		if(redissonUtil.tryLock(rLock,10,10)){
			elasticsearchTemplate.createIndex(clazz);
			indexMap.put(clazz.getName(),obj);
			redissonUtil.unLock(rLock);
		}
		return false;
	}


	/**
	 * 判断索引是否存在，如果不存在【不创建】
	 * @param elasticsearchTemplate
	 * @param clazz
	 * @return
	 */
	public static boolean indexExsitNoCreate(ElasticsearchTemplate elasticsearchTemplate, Class clazz){
		if(indexMap.containsKey(clazz.getName())){
			return true;
		}
		if(elasticsearchTemplate.indexExists(clazz)){
			indexMap.put(clazz.getName(),obj);
			return true;
		}
		return false;
	}
}
