package com.biz.crm.exception.tpm;

import com.biz.crm.exception.CrmExceptionType;

/**
 * 上账异常枚举
 * @author zeyi
 */
public enum AccountException implements CrmExceptionType {

    DATA_NOT_EXIST("tpm_100001","上账数据不存在"),
    DATA_DUPLICATE("tpm_100002","上账数据重复,请检查"),
    DATA_CODE_DUPLICATE("tpm_100003","上账编码已存在,请检查"),
    ;

    private String code;
    private String description;

    AccountException(String code, String description) {
        this.code = code;
        this.description = description;
    }

    @Override
    public String getCode() {
        return code;
    }

    @Override
    public String getDescription() {
        return description;
    }
}
