package com.biz.crm.exception.tpm;

import com.biz.crm.exception.CrmExceptionType;

/**
 * @Project crm
 * @PackageName com.biz.crm.exception.tpm
 * @ClassName FeeBudgetException
 * @Author HuangLong
 * @Date 2020/9/2 11:04
 * @Description 费用预算异常枚举
 */
public enum FeeBudgetException implements CrmExceptionType {

    DATA_NOT_EXIST("tpm_60001","费用预算数据不存在"),
    DATA_DUPLICATE("tpm_60002","费用预算数据重复,请检查"),
    DATA_CODE_DUPLICATE("tpm_60003","费用预算编码已存在,请检查"),
    NOT_ALLOW_EDIT("tpm_60004","当前费用预算已经产生明细数据,不允许编辑"),
    AMOUNT_LT_ZERO("tpm_60005","费用预算可用余额不能小于0"),

    ;

    private String code;
    private String description;

    FeeBudgetException(String code, String description) {
        this.code = code;
        this.description = description;
    }

    @Override
    public String getCode() {
        return code;
    }

    @Override
    public String getDescription() {
        return description;
    }
}
