package com.biz.crm.util;

import com.biz.crm.common.param.RedisParam;
import com.biz.crm.mdm.tableconfig.MdmColumnConfigPersonalFeign;
import com.biz.crm.nebular.mdm.tableconfig.MdmColumnConfigPersonalRedisVo;
import com.biz.crm.nebular.mdm.tableconfig.MdmColumnConfigPersonalRespVo;
import com.biz.crm.service.RedisService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.util.Assert;

import java.util.*;

/**
 * 字段配置个性设置工具类
 */
@Slf4j
public class ColumnConfigPersonalUtil {

    private static RedisService redisService;

    private static MdmColumnConfigPersonalFeign mdmColumnConfigPersonalFeign;

    public static void setRedisService(RedisService redis) {
        redisService = redis;
    }

    public static void setMdmColumnConfigPersonalFeign(MdmColumnConfigPersonalFeign columnConfigPersonalFeign) {
        mdmColumnConfigPersonalFeign = columnConfigPersonalFeign;
    }

    /**
     * 获取列表字段个性设置
     *
     * @param parentCode   菜单编码
     * @param functionCode 列表功能编码
     * @param positionCode 职位编码
     * @return
     */
    public static List<MdmColumnConfigPersonalRespVo> getColumnConfigPersonal(String parentCode, String functionCode, String positionCode) {
        Assert.hasText(parentCode, "缺失菜单编码");
        Assert.hasText(functionCode, "缺失功能编码");
        Assert.hasText(positionCode, "缺失职位编码");
        List<MdmColumnConfigPersonalRedisVo> redisList = get(parentCode, functionCode, positionCode);
        if (redisList != null && redisList.size() > 0) {
            return CrmBeanUtil.copyList(redisList, MdmColumnConfigPersonalRespVo.class);
        }
        return Collections.emptyList();
    }

    /**
     * 清除缓存
     *
     * @param parentCode   菜单编码
     * @param functionCode 列表功能编码
     */
    public static void deleteColumnConfig(String parentCode, String functionCode) {
        Assert.hasText(parentCode, "缺失菜单编码");
        Assert.hasText(functionCode, "缺失功能编码");
        Set<String> keys = new HashSet<>(16);
        keys.addAll(redisService.keys(connectParams(RedisParam.MDM_COLUMN_CONFIG_PERSONAL, parentCode, functionCode) + "*"));
        keys.addAll(redisService.keys(connectParams(RedisParam.MDM_COLUMN_CONFIG_PERSONAL_LOCK, parentCode, functionCode) + "*"));
        if (!keys.isEmpty()) {
            String[] strings = keys.toArray(new String[keys.size()]);
            redisService.del(strings);
        }
    }

    /**
     * 清除缓存
     *
     * @param parentCode   菜单编码
     * @param functionCode 列表功能编码
     * @param positionCode 职位编码
     */
    public static void deleteColumnConfigPersonal(String parentCode, String functionCode, String positionCode) {
        Assert.hasText(parentCode, "缺失菜单编码");
        Assert.hasText(functionCode, "缺失功能编码");
        Assert.hasText(positionCode, "缺失职位编码");
        Set<String> keys = new HashSet<>(16);
        keys.addAll(redisService.keys(connectParams(RedisParam.MDM_COLUMN_CONFIG_PERSONAL, parentCode, functionCode, positionCode)));
        keys.addAll(redisService.keys(connectParams(RedisParam.MDM_COLUMN_CONFIG_PERSONAL_LOCK, parentCode, functionCode, positionCode)));
        if (!keys.isEmpty()) {
            String[] strings = keys.toArray(new String[keys.size()]);
            redisService.del(strings);
        }
    }

    /*-------------------------------------------------以下为私有方法-------------------------------------------------*/

    private static List<MdmColumnConfigPersonalRedisVo> get(String parentCode, String functionCode, String positionCode) {
        List<MdmColumnConfigPersonalRedisVo> list = new ArrayList<>();
        String lockKey = connectParams(RedisParam.MDM_COLUMN_CONFIG_PERSONAL_LOCK, parentCode, functionCode, positionCode);
        String key = connectParams(RedisParam.MDM_COLUMN_CONFIG_PERSONAL, parentCode, functionCode, positionCode);
        Object o = redisService.get(lockKey);
        if (o == null) {
            Object obj = redisService.get(key);
            if (obj == null) {
                Result<List<MdmColumnConfigPersonalRedisVo>> result = mdmColumnConfigPersonalFeign.findColumnConfigPersonalRedisList(parentCode, functionCode, positionCode);
                Assert.isTrue(result.isSuccess(), "查询个性设置失败：" + result.getMessage());
                List<MdmColumnConfigPersonalRedisVo> redisList = result.getResult();
                if (redisList == null || redisList.size() == 0) {
                    redisService.setDays(lockKey, lockKey, RedisParam.TIME30);
                } else {
                    redisService.setDays(key, redisList, RedisParam.TIME30);
                    list.addAll(redisList);
                }
            } else {
                list.addAll((List<MdmColumnConfigPersonalRedisVo>) obj);
            }
        }
        return list;
    }

    private static String connectParams(String... params) {
        StringBuilder sb = new StringBuilder();
        for (String param :
                params) {
            sb.append(param).append("/");
        }
        return sb.toString();
    }


}
