package com.biz.crm.config;

import com.biz.crm.util.CommonConstant;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.ModelAndView;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.lang.reflect.Method;

/**
 * @Project crm
 * @PackageName com.biz.crm
 * @ClassName ResultResponseInterceptor
 * @Author HuangLong
 * @Date 2021/1/14 13:22
 * @Description TODO
 */
@Slf4j
@Component
public class ResultResponseInterceptor implements HandlerInterceptor {
    @Override
    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        if(handler instanceof HandlerMethod){
            HandlerMethod handlerMethod = (HandlerMethod) handler;
            Class<?> beanType = handlerMethod.getBeanType();
            Method method = handlerMethod.getMethod();
            //如果类上或者方法上有@ResultResponse注解,就给一个标识,以便在返回值body做封装的时候做判断使用(ResultResponseBodyHandler)
            if(beanType.isAnnotationPresent(ResultResponse.class)){
                request.setAttribute(CommonConstant.RESULT_RESPONSE_FLAG,CommonConstant.RESULT_RESPONSE_FLAG);
            }else if(method.isAnnotationPresent(ResultResponse.class)){
                request.setAttribute(CommonConstant.RESULT_RESPONSE_FLAG,CommonConstant.RESULT_RESPONSE_FLAG);
            }
        }
        return true;
    }
}
