package com.biz.crm.eunm.mdm;

/**
 * 动态sql枚举
 * @Author hej
 * @Created Date 2021-01-06 15:24
 **/
public enum MdmProviderEnum {
    SQL_JOIN_LEFT("left", "左"),
    SQL_JOIN_RIGHT("right", "右"),
    SQL_JOIN_ALL("all", "全部");

    private String code;
    private String des;

    MdmProviderEnum(String code, String des) {
        this.code = code;
        this.des = des;
    }

    public String getCode() {
        return code;
    }

    public String getDes() {
        return des;
    }

    public static MdmProviderEnum getEnumByCode(String code) {
        MdmProviderEnum[] values = MdmProviderEnum.values();
        for (int i = 0; i < values.length; i++) {
            MdmProviderEnum value = values[i];
            if (value.getCode().equals(code)) {
                return value;
            }
        }
        return null;
    }
}

