package com.biz.crm.util;

import com.biz.crm.base.BusinessException;
import com.biz.crm.eunm.ActivitiEnum;
import com.biz.crm.nebular.activiti.act.req.StartProcessReqVo;

import java.util.HashMap;
import java.util.Map;

/**
 * @author ren.gang
 * @ClassName SfaAuditUtils.java
 * @Description Sfa应用工作流相关工具类
 * @createTime 2020年12月03日 16:47:00
 */
public class SfaActivitiUtils {

    private static final String FORM_URL = "https";
    private static final String ACTIVITI_APPLY_KEYS = "activiti_apply_keys";

    /**
     * 创建工作流审核请求信息
     * @param userCode 用户名
     * @param posCode 岗位编码
     * @param formNo 表单号
     * @param formTypeEnum 请求类型枚举
     * @return
     */
    /**
     * 创建工作流审核请求信息
     * @param userCode 用户名
     * @param posCode 岗位编码
     * @param formNo 表单号
     * @param formTypeEnum 请求类型枚举
     * @param startDate 申请-开始时间
     * @param endDate 申请-结束时间
     * @param orgCode 组织编码
     * @return
     */
    public static StartProcessReqVo createStartProcessReqVO(String userCode, String posCode, String formNo
            , ActivitiEnum.FormTypeEnum formTypeEnum, String startDate, String endDate, String orgCode) {
        StartProcessReqVo process = new StartProcessReqVo();
        process.setUserCode(userCode);
        process.setPosCode(posCode);
        // 通过数据字段获取流程key信息
        String processKey = null;
        Map<String, String> map = DictUtil.getDictValueMapsByCodes(ACTIVITI_APPLY_KEYS);
        if(map == null) {
            throw new BusinessException("请配置<数据字典>:流程申请key集合("+ACTIVITI_APPLY_KEYS+")");
        }
        processKey = map.get(formTypeEnum.getProcessKey());
        if(StringUtils.isEmpty(processKey)) {
            throw new BusinessException("请在数据字典[流程申请key集合("+ACTIVITI_APPLY_KEYS+")]中添加字典:"+formTypeEnum.getTitle()+"申请流程("+formTypeEnum.getProcessKey()+")");
        }
        process.setProcessKey(processKey);
        process.setFormNo(formNo);
        process.setTitle(formTypeEnum.getTitle() + "申请："+userCode+"("+startDate+"至"+endDate+")");
        process.setFormUrl(FORM_URL);
        process.setCallBackFeign(formTypeEnum.getCallBackFeign());
        process.setCostType(formTypeEnum.getCostType());
        process.setFormType(formTypeEnum.getFormType());
        process.setSignTicket(System.currentTimeMillis()+"");
        // 扩展信息
        Map<String, Object> variables = new HashMap<>();
        variables.put("position_code", posCode); // 岗位编码
        variables.put("org_code", orgCode); // 组织编码
        process.setVariables(variables);

        return process;
    }
}
