package com.biz.crm.util;

import lombok.extern.slf4j.Slf4j;

import java.net.InetAddress;
import java.net.NetworkInterface;

/**
 * @author jianglong
 * @version V1.0
 * @Package com.biz.crm.util
 * @Description: TODO
 * @date 2021/1/4 下午1:18
 */
@Slf4j
public class LocalMacUtil {
    private static void getLocalMac() {
        try {
            InetAddress ia = InetAddress.getLocalHost();
            //获取网卡，获取地址
            byte[] mac = NetworkInterface.getByInetAddress(ia).getHardwareAddress();
            log.info("mac数组长度：" + mac.length);
            StringBuffer sb = new StringBuffer("");
            for (int i = 0; i < mac.length; i++) {
                if (i != 0) {
                    sb.append("-");
                }
                //字节转换为整数
                int temp = mac[i] & 0xff;
                String str = Integer.toHexString(temp);
                log.info("每8位:" + str);
                if (str.length() == 1) {
                    sb.append("0" + str);
                } else {
                    sb.append(str);
                }
            }
            log.info("本机MAC地址:" + sb.toString().toUpperCase());
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

}
