package com.biz.crm.eunm.tpm;

import org.apache.commons.lang3.StringUtils;

/**
 * @Description:  活动获取费用预算的时间区间配置(当前时间区间,当前时间区间以及未来区间)
 * @Author:: huanglong
 * @Date: 2020/10/13 11:07
 */
public enum BudgetUseDateRuleEnum {
  CURRENT("current","当前区间"),
  NO_CONTROL("no_control","不控制"),
  ;

  private String code;
  private String des;

  BudgetUseDateRuleEnum(String code, String des) {
    this.code = code;
    this.des = des;
  }

  public String getCode() {
    return code;
  }
  public String getDes() {
    return des;
  }


  public static String getStatusName(String code){
    ActApproveStatusEnum[] values = ActApproveStatusEnum.values();
    String desc=null;
    for (ActApproveStatusEnum o : values){
      if(StringUtils.equals(o.getCode(),code)){
        desc=o.getDes();
        break;
      }
    }
    return desc;
  }
}
